/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.xps;

import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationship;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.CTRelationships;
import be.fedict.eid.applet.service.signer.jaxb.opc.relationships.ObjectFactory;
import be.fedict.eid.applet.service.signer.ooxml.OOXMLURIDereferencer;
import be.fedict.eid.applet.service.signer.ooxml.OPCKeySelector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPSSignatureVerifier {
    private static final Log LOG = LogFactory.getLog(XPSSignatureVerifier.class);
    private final Unmarshaller relationshipsUnmarshaller;

    public XPSSignatureVerifier() {
        try {
            JAXBContext relationshipsJAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this.relationshipsUnmarshaller = relationshipsJAXBContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
    }

    public List<X509Certificate> getSigners(URL url) throws IOException, ParserConfigurationException, SAXException, TransformerException, MarshalException, XMLSignatureException, JAXBException {
        LinkedList<X509Certificate> signers = new LinkedList<X509Certificate>();
        List<String> signatureResourceNames = this.getSignatureResourceNames(url);
        for (String signatureResourceName : signatureResourceNames) {
            LOG.debug((Object)("signature resource name: " + signatureResourceName));
            Document signatureDocument = this.loadDocument(url, signatureResourceName);
            if (null == signatureDocument) {
                LOG.warn((Object)("signature resource not found: " + signatureResourceName));
                continue;
            }
            NodeList signatureNodeList = signatureDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (0 == signatureNodeList.getLength()) {
                LOG.debug((Object)"no signature elements present");
                continue;
            }
            Node signatureNode = signatureNodeList.item(0);
            OPCKeySelector keySelector = new OPCKeySelector(url, signatureResourceName);
            DOMValidateContext domValidateContext = new DOMValidateContext(keySelector, signatureNode);
            domValidateContext.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
            OOXMLURIDereferencer dereferencer = new OOXMLURIDereferencer(url);
            domValidateContext.setURIDereferencer(dereferencer);
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
            XMLSignature xmlSignature = xmlSignatureFactory.unmarshalXMLSignature(domValidateContext);
            boolean validity = xmlSignature.validate(domValidateContext);
            if (!validity) {
                LOG.debug((Object)"not a valid signature");
                continue;
            }
            X509Certificate signer = keySelector.getCertificate();
            signers.add(signer);
        }
        return signers;
    }

    private Document loadDocument(URL url, String signatureResourceName) throws IOException, ParserConfigurationException, SAXException {
        ZipArchiveEntry zipEntry;
        ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(url.openStream(), "UTF8", true, true);
        while (null != (zipEntry = zipInputStream.getNextZipEntry())) {
            if (!signatureResourceName.equals(zipEntry.getName())) continue;
            Document document = this.loadDocument((InputStream)zipInputStream);
            return document;
        }
        return null;
    }

    private List<String> getSignatureResourceNames(URL url) throws IOException, ParserConfigurationException, SAXException, TransformerException, JAXBException {
        ZipArchiveEntry zipEntry;
        LinkedList<String> signatureResourceNames = new LinkedList<String>();
        ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(url.openStream(), "UTF8", true, true);
        while (null != (zipEntry = zipInputStream.getNextZipEntry()) && !"_rels/.rels".equals(zipEntry.getName())) {
        }
        if (null == zipEntry) {
            LOG.debug((Object)"no _rels/.rels relationship part present");
            return signatureResourceNames;
        }
        String dsOriginPart = null;
        JAXBElement packageRelationshipsElement = (JAXBElement)this.relationshipsUnmarshaller.unmarshal((InputStream)zipInputStream);
        CTRelationships packageRelationships = (CTRelationships)packageRelationshipsElement.getValue();
        List<CTRelationship> packageRelationshipList = packageRelationships.getRelationship();
        for (CTRelationship packageRelationship : packageRelationshipList) {
            if (!"http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin".equals(packageRelationship.getType())) continue;
            dsOriginPart = packageRelationship.getTarget();
            break;
        }
        if (null == dsOriginPart) {
            LOG.debug((Object)"no Digital Signature Origin part present");
            return signatureResourceNames;
        }
        LOG.debug((Object)("Digital Signature Origin part: " + dsOriginPart));
        String dsOriginName = dsOriginPart.substring(dsOriginPart.lastIndexOf("/") + 1);
        LOG.debug((Object)("Digital Signature Origin base: " + dsOriginName));
        String dsOriginSegment = dsOriginPart.substring(0, dsOriginPart.lastIndexOf("/")) + "/";
        LOG.debug((Object)("Digital Signature Origin segment: " + dsOriginSegment));
        String dsOriginRels = dsOriginSegment + "_rels/" + dsOriginName + ".rels";
        LOG.debug((Object)("Digital Signature Origin relationship part: " + dsOriginRels));
        if (dsOriginRels.startsWith("/")) {
            dsOriginRels = dsOriginRels.substring(1);
        }
        zipInputStream = new ZipArchiveInputStream(url.openStream(), "UTF8", true, true);
        while (null != (zipEntry = zipInputStream.getNextZipEntry()) && !dsOriginRels.equals(zipEntry.getName())) {
        }
        if (null == zipEntry) {
            LOG.debug((Object)"no Digital Signature Origin relationship part present");
            return signatureResourceNames;
        }
        JAXBElement dsoRelationshipsElement = (JAXBElement)this.relationshipsUnmarshaller.unmarshal((InputStream)zipInputStream);
        CTRelationships dsoRelationships = (CTRelationships)dsoRelationshipsElement.getValue();
        List<CTRelationship> dsoRelationshipList = dsoRelationships.getRelationship();
        for (CTRelationship dsoRelationship : dsoRelationshipList) {
            if (!"http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature".equals(dsoRelationship.getType())) continue;
            String signatureResourceName = dsoRelationship.getTarget().startsWith("/") ? dsoRelationship.getTarget() : dsOriginSegment + dsoRelationship.getTarget();
            if (signatureResourceName.startsWith("/")) {
                signatureResourceName = signatureResourceName.substring(1);
            }
            LOG.debug((Object)("signature resource name: " + signatureResourceName));
            signatureResourceNames.add(signatureResourceName);
        }
        return signatureResourceNames;
    }

    private Document loadDocument(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(documentInputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }
}

