/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.ooxml;

import be.fedict.eid.applet.service.signer.ooxml.RelationshipComparator;
import be.fedict.eid.applet.service.signer.ooxml.RelationshipTransformParameterSpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RelationshipTransformService
extends TransformService {
    public static final String TRANSFORM_URI = "http://schemas.openxmlformats.org/package/2006/RelationshipTransform";
    private final List<String> sourceIds;
    private final List<String> sourceTypes;
    private static final Log LOG = LogFactory.getLog(RelationshipTransformService.class);

    public RelationshipTransformService() {
        LOG.debug((Object)"constructor");
        this.sourceIds = new LinkedList<String>();
        this.sourceTypes = new LinkedList<String>();
    }

    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        LOG.debug((Object)"init(params)");
        if (!(params instanceof RelationshipTransformParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        RelationshipTransformParameterSpec relParams = (RelationshipTransformParameterSpec)params;
        for (String sourceId : relParams.getSourceIds()) {
            this.sourceIds.add(sourceId);
        }
        for (String sourceType : relParams.getSourceTypes()) {
            this.sourceTypes.add(sourceType);
        }
    }

    public void init(XMLStructure parent, XMLCryptoContext context) throws InvalidAlgorithmParameterException {
        Node node;
        int nodeIdx;
        NodeList nodeList;
        LOG.debug((Object)"init(parent,context)");
        LOG.debug((Object)("parent java type: " + parent.getClass().getName()));
        DOMStructure domParent = (DOMStructure)parent;
        Node parentNode = domParent.getNode();
        try {
            LOG.debug((Object)("parent: " + this.toString(parentNode)));
        }
        catch (TransformerException e) {
            throw new InvalidAlgorithmParameterException();
        }
        Element nsElement = parentNode.getOwnerDocument().createElement("ns");
        nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        try {
            nodeList = XPathAPI.selectNodeList((Node)parentNode, (String)"mdssi:RelationshipReference/@SourceId", (Node)nsElement);
        }
        catch (TransformerException e) {
            LOG.error((Object)("transformer exception: " + e.getMessage()), (Throwable)e);
            throw new InvalidAlgorithmParameterException();
        }
        for (nodeIdx = 0; nodeIdx < nodeList.getLength(); ++nodeIdx) {
            node = nodeList.item(nodeIdx);
            String sourceId = node.getTextContent();
            LOG.debug((Object)("sourceId: " + sourceId));
            this.sourceIds.add(sourceId);
        }
        try {
            nodeList = XPathAPI.selectNodeList((Node)parentNode, (String)"mdssi:RelationshipsGroupReference/@SourceType", (Node)nsElement);
        }
        catch (TransformerException e) {
            LOG.error((Object)("transformer exception: " + e.getMessage()), (Throwable)e);
            throw new InvalidAlgorithmParameterException();
        }
        for (nodeIdx = 0; nodeIdx < nodeList.getLength(); ++nodeIdx) {
            node = nodeList.item(nodeIdx);
            String sourceType = node.getTextContent();
            LOG.debug((Object)("sourceType: " + sourceType));
            this.sourceTypes.add(sourceType);
        }
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        LOG.debug((Object)"marshallParams(parent,context)");
        DOMStructure domParent = (DOMStructure)parent;
        Node parentNode = domParent.getNode();
        Element parentElement = (Element)parentNode;
        parentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        Document document = parentNode.getOwnerDocument();
        for (String sourceId : this.sourceIds) {
            Element relationshipReferenceElement = document.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "mdssi:RelationshipReference");
            relationshipReferenceElement.setAttribute("SourceId", sourceId);
            parentElement.appendChild(relationshipReferenceElement);
        }
        for (String sourceType : this.sourceTypes) {
            Element relationshipsGroupReferenceElement = document.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "mdssi:RelationshipsGroupReference");
            relationshipsGroupReferenceElement.setAttribute("SourceType", sourceType);
            parentElement.appendChild(relationshipsGroupReferenceElement);
        }
    }

    public AlgorithmParameterSpec getParameterSpec() {
        LOG.debug((Object)"getParameterSpec");
        return null;
    }

    public Data transform(Data data, XMLCryptoContext context) throws TransformException {
        Document relationshipsDocument;
        LOG.debug((Object)"transform(data,context)");
        LOG.debug((Object)("data java type: " + data.getClass().getName()));
        OctetStreamData octetStreamData = (OctetStreamData)data;
        LOG.debug((Object)("URI: " + octetStreamData.getURI()));
        InputStream octetStream = octetStreamData.getOctetStream();
        try {
            relationshipsDocument = this.loadDocument(octetStream);
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
        try {
            LOG.debug((Object)("relationships document: " + this.toString(relationshipsDocument)));
        }
        catch (TransformerException e) {
            throw new TransformException(e.getMessage(), e);
        }
        Element nsElement = relationshipsDocument.createElement("ns");
        nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "http://schemas.openxmlformats.org/package/2006/relationships");
        Element relationshipsElement = relationshipsDocument.getDocumentElement();
        NodeList childNodes = relationshipsElement.getChildNodes();
        for (int nodeIdx = 0; nodeIdx < childNodes.getLength(); ++nodeIdx) {
            Node childNode = childNodes.item(nodeIdx);
            if (1 != childNode.getNodeType()) {
                LOG.debug((Object)"removing node");
                relationshipsElement.removeChild(childNode);
                --nodeIdx;
                continue;
            }
            Element childElement = (Element)childNode;
            String idAttribute = childElement.getAttribute("Id");
            String typeAttribute = childElement.getAttribute("Type");
            LOG.debug((Object)("Relationship id attribute: " + idAttribute));
            LOG.debug((Object)("Relationship type attribute: " + typeAttribute));
            if (!this.sourceIds.contains(idAttribute) && !this.sourceTypes.contains(typeAttribute)) {
                LOG.debug((Object)("removing Relationship element: " + idAttribute));
                relationshipsElement.removeChild(childNode);
                --nodeIdx;
            }
            if (null != childElement.getAttributeNode("TargetMode")) continue;
            childElement.setAttribute("TargetMode", "Internal");
        }
        LOG.debug((Object)("# Relationship elements: " + relationshipsElement.getElementsByTagName("*").getLength()));
        this.sortRelationshipElements(relationshipsElement);
        try {
            return this.toOctetStreamData(relationshipsDocument);
        }
        catch (TransformerException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private void sortRelationshipElements(Element relationshipsElement) {
        LinkedList<Element> relationshipElements = new LinkedList<Element>();
        NodeList relationshipNodes = relationshipsElement.getElementsByTagName("*");
        int nodeCount = relationshipNodes.getLength();
        for (int nodeIdx = 0; nodeIdx < nodeCount; ++nodeIdx) {
            Node relationshipNode = relationshipNodes.item(0);
            Element relationshipElement = (Element)relationshipNode;
            LOG.debug((Object)("unsorted Id: " + relationshipElement.getAttribute("Id")));
            relationshipElements.add(relationshipElement);
            relationshipsElement.removeChild(relationshipNode);
        }
        Collections.sort(relationshipElements, new RelationshipComparator());
        for (Element relationshipElement : relationshipElements) {
            LOG.debug((Object)("sorted Id: " + relationshipElement.getAttribute("Id")));
            relationshipsElement.appendChild(relationshipElement);
        }
    }

    private String toString(Node dom) throws TransformerException {
        DOMSource source = new DOMSource(dom);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }

    private OctetStreamData toOctetStreamData(Node node) throws TransformerException {
        DOMSource source = new DOMSource(node);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, result);
        LOG.debug((Object)("result: " + new String(outputStream.toByteArray())));
        return new OctetStreamData(new ByteArrayInputStream(outputStream.toByteArray()));
    }

    private Document loadDocument(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(documentInputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    public Data transform(Data data, XMLCryptoContext context, OutputStream os) throws TransformException {
        LOG.debug((Object)"transform(data,context,os)");
        return null;
    }

    public boolean isFeatureSupported(String feature) {
        LOG.debug((Object)"isFeatureSupported(feature)");
        return false;
    }
}

