/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.ooxml;

import be.fedict.eid.applet.service.signer.AbstractXmlSignatureService;
import be.fedict.eid.applet.service.signer.facets.KeyInfoSignatureFacet;
import be.fedict.eid.applet.service.signer.facets.XAdESSignatureFacet;
import be.fedict.eid.applet.service.signer.ooxml.OOXMLSignatureFacet;
import be.fedict.eid.applet.service.signer.ooxml.OOXMLURIDereferencer;
import be.fedict.eid.applet.service.signer.ooxml.Office2010SignatureFacet;
import be.fedict.eid.applet.service.signer.time.ConstantLocalClock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.crypto.URIDereferencer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractOOXMLSignatureService
extends AbstractXmlSignatureService {
    static final Log LOG = LogFactory.getLog(AbstractOOXMLSignatureService.class);
    private final XAdESSignatureFacet xadesSignatureFacet;

    protected AbstractOOXMLSignatureService() {
        ConstantLocalClock clock = new ConstantLocalClock();
        this.addSignatureFacet(new OOXMLSignatureFacet(this, clock));
        this.addSignatureFacet(new KeyInfoSignatureFacet(true, false, false));
        this.xadesSignatureFacet = new XAdESSignatureFacet(clock);
        this.xadesSignatureFacet.setXadesNamespacePrefix("xd");
        this.xadesSignatureFacet.setIdSignedProperties("idSignedProperties");
        this.xadesSignatureFacet.setSignaturePolicyImplied(true);
        this.xadesSignatureFacet.setIssuerNameNoReverseOrder(true);
        this.setSignatureId("idPackageSignature");
        this.addSignatureFacet(this.xadesSignatureFacet);
        this.addSignatureFacet(new Office2010SignatureFacet());
    }

    protected XAdESSignatureFacet getXAdESSignatureFacet() {
        return this.xadesSignatureFacet;
    }

    protected String getSignatureDescription() {
        return "Office OpenXML Document";
    }

    public String getFilesDigestAlgorithm() {
        return null;
    }

    protected final URIDereferencer getURIDereferencer() {
        URL ooxmlUrl = this.getOfficeOpenXMLDocumentURL();
        return new OOXMLURIDereferencer(ooxmlUrl);
    }

    protected String getCanonicalizationMethod() {
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    protected abstract OutputStream getSignedOfficeOpenXMLDocumentOutputStream();

    protected abstract URL getOfficeOpenXMLDocumentURL();

    private void outputSignedOfficeOpenXMLDocument(byte[] signatureData) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        LOG.debug((Object)"output signed Office OpenXML document");
        OutputStream signedOOXMLOutputStream = this.getSignedOfficeOpenXMLDocumentOutputStream();
        if (null == signedOOXMLOutputStream) {
            throw new NullPointerException("signedOOXMLOutputStream is null");
        }
        String signatureZipEntryName = "_xmlsignatures/sig-" + UUID.randomUUID().toString() + ".xml";
        LOG.debug((Object)("signature ZIP entry name: " + signatureZipEntryName));
        ZipOutputStream zipOutputStream = this.copyOOXMLContent(signatureZipEntryName, signedOOXMLOutputStream);
        ZipEntry zipEntry = new ZipEntry(signatureZipEntryName);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.write((byte[])signatureData, (OutputStream)zipOutputStream);
        zipOutputStream.close();
    }

    private ZipOutputStream copyOOXMLContent(String signatureZipEntryName, OutputStream signedOOXMLOutputStream) throws IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        ZipEntry zipEntry;
        ZipOutputStream zipOutputStream = new ZipOutputStream(signedOOXMLOutputStream);
        ZipInputStream zipInputStream = new ZipInputStream(this.getOfficeOpenXMLDocumentURL().openStream());
        boolean hasOriginSigsRels = false;
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            LOG.debug((Object)("copy ZIP entry: " + zipEntry.getName()));
            ZipEntry newZipEntry = new ZipEntry(zipEntry.getName());
            zipOutputStream.putNextEntry(newZipEntry);
            if ("[Content_Types].xml".equals(zipEntry.getName())) {
                Document contentTypesDocument = this.loadDocumentNoClose(zipInputStream);
                Element typesElement = contentTypesDocument.getDocumentElement();
                Element overrideElement = contentTypesDocument.createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "Override");
                overrideElement.setAttribute("PartName", "/" + signatureZipEntryName);
                overrideElement.setAttribute("ContentType", "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml");
                typesElement.appendChild(overrideElement);
                Element nsElement = contentTypesDocument.createElement("ns");
                nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "http://schemas.openxmlformats.org/package/2006/content-types");
                NodeList nodeList = XPathAPI.selectNodeList((Node)contentTypesDocument, (String)"/tns:Types/tns:Default[@Extension='sigs']", (Node)nsElement);
                if (0 == nodeList.getLength()) {
                    Element defaultElement = contentTypesDocument.createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "Default");
                    defaultElement.setAttribute("Extension", "sigs");
                    defaultElement.setAttribute("ContentType", "application/vnd.openxmlformats-package.digital-signature-origin");
                    typesElement.appendChild(defaultElement);
                }
                this.writeDocumentNoClosing(contentTypesDocument, zipOutputStream, false);
                continue;
            }
            if ("_rels/.rels".equals(zipEntry.getName())) {
                Document relsDocument = this.loadDocumentNoClose(zipInputStream);
                Element nsElement = relsDocument.createElement("ns");
                nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "http://schemas.openxmlformats.org/package/2006/relationships");
                NodeList nodeList = XPathAPI.selectNodeList((Node)relsDocument, (String)"/tns:Relationships/tns:Relationship[@Target='_xmlsignatures/origin.sigs']", (Node)nsElement);
                if (0 == nodeList.getLength()) {
                    Element relationshipElement = relsDocument.createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationship");
                    relationshipElement.setAttribute("Id", "rel-id-" + UUID.randomUUID().toString());
                    relationshipElement.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    relationshipElement.setAttribute("Target", "_xmlsignatures/origin.sigs");
                    relsDocument.getDocumentElement().appendChild(relationshipElement);
                }
                this.writeDocumentNoClosing(relsDocument, zipOutputStream, false);
                continue;
            }
            if ("_xmlsignatures/_rels/origin.sigs.rels".equals(zipEntry.getName())) {
                hasOriginSigsRels = true;
                Document originSignRelsDocument = this.loadDocumentNoClose(zipInputStream);
                Element relationshipElement = originSignRelsDocument.createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationship");
                String relationshipId = "rel-" + UUID.randomUUID().toString();
                relationshipElement.setAttribute("Id", relationshipId);
                relationshipElement.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
                String target = FilenameUtils.getName((String)signatureZipEntryName);
                LOG.debug((Object)("target: " + target));
                relationshipElement.setAttribute("Target", target);
                originSignRelsDocument.getDocumentElement().appendChild(relationshipElement);
                this.writeDocumentNoClosing(originSignRelsDocument, zipOutputStream, false);
                continue;
            }
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
        }
        if (!hasOriginSigsRels) {
            this.addOriginSigsRels(signatureZipEntryName, zipOutputStream);
            this.addOriginSigs(zipOutputStream);
        }
        zipInputStream.close();
        return zipOutputStream;
    }

    private void addOriginSigs(ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry("_xmlsignatures/origin.sigs"));
    }

    private void addOriginSigsRels(String signatureZipEntryName, ZipOutputStream zipOutputStream) throws ParserConfigurationException, IOException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document originSignRelsDocument = documentBuilder.newDocument();
        Element relationshipsElement = originSignRelsDocument.createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationships");
        relationshipsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        originSignRelsDocument.appendChild(relationshipsElement);
        Element relationshipElement = originSignRelsDocument.createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationship");
        String relationshipId = "rel-" + UUID.randomUUID().toString();
        relationshipElement.setAttribute("Id", relationshipId);
        relationshipElement.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
        String target = FilenameUtils.getName((String)signatureZipEntryName);
        LOG.debug((Object)("target: " + target));
        relationshipElement.setAttribute("Target", target);
        relationshipsElement.appendChild(relationshipElement);
        zipOutputStream.putNextEntry(new ZipEntry("_xmlsignatures/_rels/origin.sigs.rels"));
        this.writeDocumentNoClosing(originSignRelsDocument, zipOutputStream, false);
    }

    protected OutputStream getSignedDocumentOutputStream() {
        LOG.debug((Object)"get signed document output stream");
        OOXMLSignedDocumentOutputStream signedDocumentOutputStream = new OOXMLSignedDocumentOutputStream();
        return signedDocumentOutputStream;
    }

    private class OOXMLSignedDocumentOutputStream
    extends ByteArrayOutputStream {
        private OOXMLSignedDocumentOutputStream() {
        }

        public void close() throws IOException {
            LOG.debug((Object)"close OOXML signed document output stream");
            super.close();
            try {
                AbstractOOXMLSignatureService.this.outputSignedOfficeOpenXMLDocument(this.toByteArray());
            }
            catch (Exception e) {
                throw new IOException("generic error: " + e.getMessage(), e);
            }
        }
    }
}

