/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.facets.SignaturePolicyService;
import be.fedict.eid.applet.service.signer.facets.XAdESNamespacePrefixMapper;
import be.fedict.eid.applet.service.signer.jaxb.xades132.AnyType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CertIDListType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.CertIDType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.ClaimedRolesListType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.DigestAlgAndValueType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.IdentifierType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.ObjectFactory;
import be.fedict.eid.applet.service.signer.jaxb.xades132.ObjectIdentifierType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.QualifyingPropertiesType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.SigPolicyQualifiersListType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.SignaturePolicyIdType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.SignaturePolicyIdentifierType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.SignedPropertiesType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.SignedSignaturePropertiesType;
import be.fedict.eid.applet.service.signer.jaxb.xades132.SignerRoleType;
import be.fedict.eid.applet.service.signer.jaxb.xmldsig.DigestMethodType;
import be.fedict.eid.applet.service.signer.jaxb.xmldsig.X509IssuerSerialType;
import be.fedict.eid.applet.service.signer.time.Clock;
import be.fedict.eid.applet.service.signer.time.LocalClock;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.PrincipalUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAdESSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(XAdESSignatureFacet.class);
    private static final String XADES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    private final DatatypeFactory datatypeFactory;
    private final ObjectFactory xadesObjectFactory;
    private final be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory xmldsigObjectFactory;
    private final Marshaller marshaller;
    private final Clock clock;
    private final String digestAlgorithm;
    private final String xmlDigestAlgorithm;
    private final SignaturePolicyService signaturePolicyService;
    private String idSignedProperties;
    private boolean signaturePolicyImplied;
    private String xadesNamespacePrefix;
    private String role;
    private boolean issuerNameNoReverseOrder = false;

    public XAdESSignatureFacet() {
        this(new LocalClock());
    }

    public XAdESSignatureFacet(Clock clock) {
        this(clock, "SHA-1");
    }

    public XAdESSignatureFacet(String digestAlgorithm) {
        this(new LocalClock(), digestAlgorithm);
    }

    public XAdESSignatureFacet(String digestAlgorithm, SignaturePolicyService signaturePolicyService) {
        this(new LocalClock(), digestAlgorithm, signaturePolicyService);
    }

    public XAdESSignatureFacet(SignaturePolicyService signaturePolicyService) {
        this(new LocalClock(), "SHA-1", signaturePolicyService);
    }

    public XAdESSignatureFacet(Clock clock, String digestAlgorithm) {
        this(clock, digestAlgorithm, null);
    }

    public XAdESSignatureFacet(Clock clock, String digestAlgorithm, SignaturePolicyService signaturePolicyService) {
        this.clock = clock;
        this.digestAlgorithm = digestAlgorithm;
        this.xmlDigestAlgorithm = XAdESSignatureFacet.getXmlDigestAlgo(this.digestAlgorithm);
        this.signaturePolicyService = signaturePolicyService;
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("datatype config error: " + e.getMessage(), e);
        }
        this.xadesObjectFactory = new ObjectFactory();
        this.xmldsigObjectFactory = new be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new XAdESNamespacePrefixMapper(this.xadesNamespacePrefix));
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
        LOG.debug((Object)"postSign");
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        SignaturePolicyIdentifierType signaturePolicyIdentifier;
        LOG.debug((Object)"preSign");
        QualifyingPropertiesType qualifyingProperties = this.xadesObjectFactory.createQualifyingPropertiesType();
        qualifyingProperties.setTarget("#" + signatureId);
        SignedPropertiesType signedProperties = this.xadesObjectFactory.createSignedPropertiesType();
        String signedPropertiesId = null != this.idSignedProperties ? this.idSignedProperties : signatureId + "-xades";
        signedProperties.setId(signedPropertiesId);
        qualifyingProperties.setSignedProperties(signedProperties);
        SignedSignaturePropertiesType signedSignatureProperties = this.xadesObjectFactory.createSignedSignaturePropertiesType();
        signedProperties.setSignedSignatureProperties(signedSignatureProperties);
        GregorianCalendar signingTime = new GregorianCalendar(TimeZone.getTimeZone("Z"));
        Date currentClockValue = this.clock.getTime();
        signingTime.setTime(currentClockValue);
        XMLGregorianCalendar xmlGregorianCalendar = this.datatypeFactory.newXMLGregorianCalendar(signingTime);
        xmlGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
        signedSignatureProperties.setSigningTime(xmlGregorianCalendar);
        if (null == signingCertificateChain || signingCertificateChain.isEmpty()) {
            throw new RuntimeException("no signing certificate chain available");
        }
        X509Certificate signingCertificate = signingCertificateChain.get(0);
        CertIDType signingCertificateId = XAdESSignatureFacet.getCertID(signingCertificate, this.xadesObjectFactory, this.xmldsigObjectFactory, this.digestAlgorithm, this.issuerNameNoReverseOrder);
        CertIDListType signingCertificates = this.xadesObjectFactory.createCertIDListType();
        signingCertificates.getCert().add(signingCertificateId);
        signedSignatureProperties.setSigningCertificate(signingCertificates);
        if (null != this.role && !this.role.isEmpty()) {
            SignerRoleType signerRole = this.xadesObjectFactory.createSignerRoleType();
            signedSignatureProperties.setSignerRole(signerRole);
            ClaimedRolesListType claimedRolesList = this.xadesObjectFactory.createClaimedRolesListType();
            signerRole.setClaimedRoles(claimedRolesList);
            AnyType claimedRole = this.xadesObjectFactory.createAnyType();
            claimedRole.getContent().add(this.role);
            claimedRolesList.getClaimedRole().add(claimedRole);
        }
        if (null != this.signaturePolicyService) {
            signaturePolicyIdentifier = this.xadesObjectFactory.createSignaturePolicyIdentifierType();
            signedSignatureProperties.setSignaturePolicyIdentifier(signaturePolicyIdentifier);
            SignaturePolicyIdType signaturePolicyId = this.xadesObjectFactory.createSignaturePolicyIdType();
            signaturePolicyIdentifier.setSignaturePolicyId(signaturePolicyId);
            ObjectIdentifierType objectIdentifier = this.xadesObjectFactory.createObjectIdentifierType();
            signaturePolicyId.setSigPolicyId(objectIdentifier);
            IdentifierType identifier = this.xadesObjectFactory.createIdentifierType();
            objectIdentifier.setIdentifier(identifier);
            identifier.setValue(this.signaturePolicyService.getSignaturePolicyIdentifier());
            objectIdentifier.setDescription(this.signaturePolicyService.getSignaturePolicyDescription());
            byte[] signaturePolicyDocumentData = this.signaturePolicyService.getSignaturePolicyDocument();
            DigestAlgAndValueType sigPolicyHash = XAdESSignatureFacet.getDigestAlgAndValue(signaturePolicyDocumentData, this.xadesObjectFactory, this.xmldsigObjectFactory, this.digestAlgorithm);
            signaturePolicyId.setSigPolicyHash(sigPolicyHash);
            String signaturePolicyDownloadUrl = this.signaturePolicyService.getSignaturePolicyDownloadUrl();
            if (null != signaturePolicyDownloadUrl) {
                SigPolicyQualifiersListType sigPolicyQualifiers = this.xadesObjectFactory.createSigPolicyQualifiersListType();
                signaturePolicyId.setSigPolicyQualifiers(sigPolicyQualifiers);
                AnyType sigPolicyQualifier = this.xadesObjectFactory.createAnyType();
                sigPolicyQualifiers.getSigPolicyQualifier().add(sigPolicyQualifier);
                JAXBElement<String> spUriElement = this.xadesObjectFactory.createSPURI(signaturePolicyDownloadUrl);
                sigPolicyQualifier.getContent().add(spUriElement);
            }
        } else if (this.signaturePolicyImplied) {
            signaturePolicyIdentifier = this.xadesObjectFactory.createSignaturePolicyIdentifierType();
            signedSignatureProperties.setSignaturePolicyIdentifier(signaturePolicyIdentifier);
            signaturePolicyIdentifier.setSignaturePolicyImplied("");
        }
        Node qualifyingPropertiesNode = this.marshallQualifyingProperties(document, this.xadesObjectFactory, qualifyingProperties);
        LinkedList<DOMStructure> xadesObjectContent = new LinkedList<DOMStructure>();
        xadesObjectContent.add(new DOMStructure(qualifyingPropertiesNode));
        XMLObject xadesObject = signatureFactory.newXMLObject(xadesObjectContent, null, null, null);
        objects.add(xadesObject);
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.xmlDigestAlgorithm, null);
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        Transform exclusiveTransform = signatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
        transforms.add(exclusiveTransform);
        Reference reference = signatureFactory.newReference("#" + signedPropertiesId, digestMethod, transforms, XADES_TYPE, null);
        references.add(reference);
    }

    public static String getXmlDigestAlgo(String digestAlgo) {
        if ("SHA-1".equals(digestAlgo)) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if ("SHA-256".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        if ("SHA-512".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }
        throw new RuntimeException("unsupported digest algo: " + digestAlgo);
    }

    private Node marshallQualifyingProperties(Document document, ObjectFactory xadesObjectFactory, QualifyingPropertiesType qualifyingProperties) {
        Element marshallNode = document.createElement("marshall-node");
        try {
            this.marshaller.marshal(xadesObjectFactory.createQualifyingProperties(qualifyingProperties), (Node)marshallNode);
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        Node qualifyingPropertiesNode = marshallNode.getFirstChild();
        return qualifyingPropertiesNode;
    }

    public static DigestAlgAndValueType getDigestAlgAndValue(byte[] data, ObjectFactory xadesObjectFactory, be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory xmldsigObjectFactory, String digestAlgorithm) {
        MessageDigest messageDigest;
        DigestAlgAndValueType digestAlgAndValue = xadesObjectFactory.createDigestAlgAndValueType();
        DigestMethodType digestMethod = xmldsigObjectFactory.createDigestMethodType();
        digestAlgAndValue.setDigestMethod(digestMethod);
        String xmlDigestAlgorithm = XAdESSignatureFacet.getXmlDigestAlgo(digestAlgorithm);
        digestMethod.setAlgorithm(xmlDigestAlgorithm);
        try {
            messageDigest = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("message digest algo error: " + e.getMessage(), e);
        }
        byte[] digestValue = messageDigest.digest(data);
        digestAlgAndValue.setDigestValue(digestValue);
        return digestAlgAndValue;
    }

    public static CertIDType getCertID(X509Certificate certificate, ObjectFactory xadesObjectFactory, be.fedict.eid.applet.service.signer.jaxb.xmldsig.ObjectFactory xmldsigObjectFactory, String digestAlgorithm, boolean issuerNameNoReverseOrder) {
        byte[] encodedCertificate;
        String issuerName;
        CertIDType certId = xadesObjectFactory.createCertIDType();
        X509IssuerSerialType issuerSerial = xmldsigObjectFactory.createX509IssuerSerialType();
        certId.setIssuerSerial(issuerSerial);
        if (issuerNameNoReverseOrder) {
            try {
                issuerName = PrincipalUtil.getIssuerX509Principal((X509Certificate)certificate).getName().replace(",", ", ");
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException("cert encoding error: " + e.getMessage(), e);
            }
        } else {
            issuerName = certificate.getIssuerX500Principal().toString();
        }
        issuerSerial.setX509IssuerName(issuerName);
        issuerSerial.setX509SerialNumber(certificate.getSerialNumber());
        try {
            encodedCertificate = certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("certificate encoding error: " + e.getMessage(), e);
        }
        DigestAlgAndValueType certDigest = XAdESSignatureFacet.getDigestAlgAndValue(encodedCertificate, xadesObjectFactory, xmldsigObjectFactory, digestAlgorithm);
        certId.setCertDigest(certDigest);
        return certId;
    }

    public void setIdSignedProperties(String idSignedProperties) {
        this.idSignedProperties = idSignedProperties;
    }

    public void setSignaturePolicyImplied(boolean signaturePolicyImplied) {
        this.signaturePolicyImplied = signaturePolicyImplied;
    }

    public void setXadesNamespacePrefix(String xadesNamespacePrefix) {
        this.xadesNamespacePrefix = xadesNamespacePrefix;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setIssuerNameNoReverseOrder(boolean reverseOrder) {
        this.issuerNameNoReverseOrder = reverseOrder;
    }
}

