/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.jaxb.identity.GenderType;
import be.fedict.eid.applet.service.signer.jaxb.identity.IdentityType;
import be.fedict.eid.applet.service.signer.jaxb.identity.ObjectFactory;
import be.fedict.eid.applet.service.signer.jaxb.identity.PhotoType;
import be.fedict.eid.applet.service.spi.IdentityDTO;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySignatureFacet
implements SignatureFacet {
    public static final String REFERENCE_TYPE = "be:fedict:eid:identity:1.0";
    public static final String NAMESPACE_URI = "be:fedict:eid:identity:1.0";
    private final IdentityDTO identityDTO;
    private final byte[] photoData;
    private final ObjectFactory objectFactory;
    private final Marshaller marshaller;
    private final String xmlDigestAlgo;

    public IdentitySignatureFacet(IdentityDTO identity, byte[] photo, String digestAlgo) {
        this.identityDTO = identity;
        this.photoData = photo;
        this.objectFactory = new ObjectFactory();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this.marshaller = jaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        this.xmlDigestAlgo = this.getXmlDigestAlgo(digestAlgo);
    }

    private String getXmlDigestAlgo(String digestAlgo) {
        if ("SHA-1".equals(digestAlgo)) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if ("SHA-256".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        if ("SHA-512".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }
        throw new RuntimeException("unsupported digest algo: " + digestAlgo);
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        IdentityType identity = this.objectFactory.createIdentityType();
        String identityId = "identity-" + UUID.randomUUID().toString();
        identity.setId(identityId);
        if (null != this.identityDTO) {
            identity.setFirstName(this.identityDTO.firstName);
            identity.setName(this.identityDTO.name);
            identity.setMiddleName(this.identityDTO.middleName);
            GenderType gender = this.identityDTO.male ? GenderType.MALE : GenderType.FEMALE;
            identity.setGender(gender);
        }
        if (null != this.photoData) {
            PhotoType photo = this.objectFactory.createPhotoType();
            photo.setValue(this.photoData);
            photo.setMimeType("image/jpeg");
            identity.setPhoto(photo);
        }
        Element marshallNode = document.createElement("marshall-node");
        try {
            this.marshaller.marshal(this.objectFactory.createIdentity(identity), (Node)marshallNode);
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        Node identityNode = marshallNode.getFirstChild();
        String objectId = "identity-object-" + UUID.randomUUID().toString();
        LinkedList<DOMStructure> identityObjectContent = new LinkedList<DOMStructure>();
        identityObjectContent.add(new DOMStructure(identityNode));
        XMLObject identityObject = signatureFactory.newXMLObject(identityObjectContent, objectId, null, null);
        objects.add(identityObject);
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.xmlDigestAlgo, null);
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        Transform exclusiveTransform = signatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
        transforms.add(exclusiveTransform);
        Reference reference = signatureFactory.newReference("#" + objectId, digestMethod, transforms, "be:fedict:eid:identity:1.0", null);
        references.add(reference);
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
    }
}

