/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import be.fedict.eid.applet.service.signer.SignatureFacet;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoSignatureFacet
implements SignatureFacet {
    private final String xmlDigestAlgorithm;

    public CoSignatureFacet() {
        this("SHA-1");
    }

    public CoSignatureFacet(String digestAlgorithm) {
        this.xmlDigestAlgorithm = this.getXmlDigestAlgo(digestAlgorithm);
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        DigestMethod digestMethod = signatureFactory.newDigestMethod(this.xmlDigestAlgorithm, null);
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        HashMap<String, String> xpathNamespaceMap = new HashMap<String, String>();
        xpathNamespaceMap.put("ds", "http://www.w3.org/2000/09/xmldsig#");
        Transform envelopedTransform = signatureFactory.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec("not(ancestor-or-self::ds:Signature)", xpathNamespaceMap));
        transforms.add(envelopedTransform);
        Transform exclusiveTransform = signatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        transforms.add(exclusiveTransform);
        Reference reference = signatureFactory.newReference("", digestMethod, transforms, null, null);
        references.add(reference);
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
    }

    private String getXmlDigestAlgo(String digestAlgo) {
        if ("SHA-1".equals(digestAlgo)) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if ("SHA-256".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        if ("SHA-512".equals(digestAlgo)) {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }
        throw new RuntimeException("unsupported digest algo: " + digestAlgo);
    }
}

