/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class VcardLight {
    public static final String MIME_TYPE = "text/directory;profile=vCard";
    private PrintWriter vcard;

    public void open() {
        this.vcard.println("BEGIN:vCARD");
        this.vcard.println("VERSION:3.0");
    }

    public void addName(String firstName, String middleName, String name) {
        String nameFN = firstName + " " + name;
        String nameN = name + ";" + firstName + ";";
        nameN = nameN + (null != middleName ? middleName + ";" : ";");
        this.vcard.println("FN:" + nameFN);
        this.vcard.println("N:" + nameN);
    }

    public void addAddress(String streetNo, String zip, String municipality) {
        String adr = ";;";
        adr = adr + (null != streetNo ? streetNo + ";" : ";");
        adr = adr + (null != municipality ? municipality + ";" : ";");
        adr = adr + ";";
        adr = adr + (null != zip ? zip + ";" : ";");
        adr = adr + "Belgium";
        this.vcard.println("ADR;TYPE=home:" + adr);
    }

    public void addBorn(Date birthday) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        String bday = fmt.format(birthday);
        this.vcard.println("BDAY:" + bday);
    }

    public void addImage(byte[] image) throws IOException {
        byte[] enc = Base64.encodeBase64((byte[])image);
        String str = "PHOTO;ENCODING=b;TYPE=JPEG:" + new String(enc);
        int length = str.length();
        if (length > 76) {
            StringBuffer buf = new StringBuffer();
            buf.append(str.substring(0, 76));
            for (int i = 76; i < length; i += 75) {
                buf.append("\n ");
                if (length > i + 75) {
                    buf.append(str.substring(i, i + 75));
                    continue;
                }
                buf.append(str.substring(i));
            }
            this.vcard.println(buf.toString());
        }
    }

    public void close() {
        this.vcard.println("END:vCard");
        this.vcard.close();
    }

    public VcardLight(OutputStream outStream) {
        this.vcard = new PrintWriter(outStream);
    }
}

