/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.tlv;

import be.fedict.eid.applet.service.impl.tlv.DataConvertor;
import be.fedict.eid.applet.service.impl.tlv.DataConvertorException;
import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateOfBirthDataConvertor
implements DataConvertor<GregorianCalendar> {
    private static final Log LOG = LogFactory.getLog(DateOfBirthDataConvertor.class);
    private static final String[][] MONTHS = new String[][]{{"JAN"}, {"FEV", "FEB"}, {"MARS", "MAAR", "M\u00c4R"}, {"AVR", "APR"}, {"MAI", "MEI"}, {"JUIN", "JUN"}, {"JUIL", "JUL"}, {"AOUT", "AUG"}, {"SEPT", "SEP"}, {"OCT", "OKT"}, {"NOV"}, {"DEC", "DEZ"}};

    @Override
    public GregorianCalendar convert(byte[] value) throws DataConvertorException {
        String dateOfBirthStr;
        try {
            dateOfBirthStr = new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DataConvertorException("UTF-8 not supported");
        }
        LOG.debug((Object)dateOfBirthStr);
        int spaceIdx = dateOfBirthStr.indexOf(32);
        if (-1 == spaceIdx) {
            spaceIdx = dateOfBirthStr.indexOf(46);
        }
        if (spaceIdx > 0) {
            String dayStr = dateOfBirthStr.substring(0, spaceIdx);
            int day = Integer.parseInt(dayStr);
            String monthStr = dateOfBirthStr.substring(spaceIdx + 1, dateOfBirthStr.length() - 4 - 1);
            String yearStr = dateOfBirthStr.substring(dateOfBirthStr.length() - 4);
            int year = Integer.parseInt(yearStr);
            int month = this.toMonth(monthStr);
            return new GregorianCalendar(year, month, day);
        }
        if (dateOfBirthStr.length() == 4) {
            return new GregorianCalendar(Integer.parseInt(dateOfBirthStr), 0, 1);
        }
        throw new DataConvertorException("Unsupported Birth Date Format [" + dateOfBirthStr + "]");
    }

    private int toMonth(String monthStr) throws DataConvertorException {
        monthStr = monthStr.trim();
        for (int monthIdx = 0; monthIdx < MONTHS.length; ++monthIdx) {
            String[] monthNames;
            for (String monthName : monthNames = MONTHS[monthIdx]) {
                if (!monthName.equals(monthStr)) continue;
                return monthIdx;
            }
        }
        throw new DataConvertorException("unknown month: " + monthStr);
    }
}

