/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.EIdCertsData;
import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.Identity;
import be.fedict.eid.applet.service.impl.AuthenticationChallenge;
import be.fedict.eid.applet.service.impl.RequestContext;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.UserIdentifierUtil;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.tlv.TlvParser;
import be.fedict.eid.applet.service.spi.AuditService;
import be.fedict.eid.applet.service.spi.AuthenticationService;
import be.fedict.eid.applet.service.spi.CertificateSecurityException;
import be.fedict.eid.applet.service.spi.ChannelBindingService;
import be.fedict.eid.applet.service.spi.ExpiredCertificateSecurityException;
import be.fedict.eid.applet.service.spi.IdentityIntegrityService;
import be.fedict.eid.applet.service.spi.RevokedCertificateSecurityException;
import be.fedict.eid.applet.service.spi.TrustCertificateSecurityException;
import be.fedict.eid.applet.shared.AuthenticationContract;
import be.fedict.eid.applet.shared.AuthenticationDataMessage;
import be.fedict.eid.applet.shared.ErrorCode;
import be.fedict.eid.applet.shared.FinishedMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesMessage(value=AuthenticationDataMessage.class)
public class AuthenticationDataMessageHandler
implements MessageHandler<AuthenticationDataMessage> {
    public static final String AUTHENTICATED_USER_IDENTIFIER_SESSION_ATTRIBUTE = "eid.identifier";
    private static final Log LOG = LogFactory.getLog(AuthenticationDataMessageHandler.class);
    @InitParam(value="AuthenticationService")
    private ServiceLocator<AuthenticationService> authenticationServiceLocator;
    @InitParam(value="AuditService")
    private ServiceLocator<AuditService> auditServiceLocator;
    @InitParam(value="ChannelBindingService")
    private ServiceLocator<ChannelBindingService> channelBindingServiceLocator;
    @InitParam(value="Hostname")
    private String hostname;
    @InitParam(value="InetAddress")
    private InetAddress inetAddress;
    @InitParam(value="ChallengeMaxMaturity")
    private Long maxMaturity;
    private X509Certificate serverCertificate;
    @InitParam(value="SessionIdChannelBinding")
    private boolean sessionIdChannelBinding;
    public static final String AUTHN_SERVICE_INIT_PARAM_NAME = "AuthenticationService";
    public static final String AUDIT_SERVICE_INIT_PARAM_NAME = "AuditService";
    public static final String CHALLENGE_MAX_MATURITY_INIT_PARAM_NAME = "ChallengeMaxMaturity";
    public static final String NRCID_SECRET_INIT_PARAM_NAME = "NRCIDSecret";
    public static final String NRCID_ORG_ID_INIT_PARAM_NAME = "NRCIDOrgId";
    public static final String NRCID_APP_ID_INIT_PARAM_NAME = "NRCIDAppId";
    @InitParam(value="NRCIDSecret")
    private String nrcidSecret;
    @InitParam(value="NRCIDOrgId")
    private String nrcidOrgId;
    @InitParam(value="NRCIDAppId")
    private String nrcidAppId;
    @InitParam(value="IdentityIntegrityService")
    private ServiceLocator<IdentityIntegrityService> identityIntegrityServiceLocator;

    @Override
    public Object handleMessage(AuthenticationDataMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        block60: {
            byte[] toBeSigned;
            byte[] challenge;
            LOG.debug((Object)"authentication data message received");
            if (null == message.authnCert) {
                String msg = "authentication certificate not present";
                LOG.warn((Object)msg);
                throw new ServletException(msg);
            }
            byte[] signatureValue = message.signatureValue;
            LOG.debug((Object)("authn signing certificate subject: " + message.authnCert.getSubjectX500Principal()));
            PublicKey signingKey = message.authnCert.getPublicKey();
            if (this.sessionIdChannelBinding) {
                this.checkSessionIdChannelBinding(message, request);
                if (null == this.serverCertificate) {
                    LOG.warn((Object)"adviced to use in combination with server certificate channel binding");
                }
            }
            ChannelBindingService channelBindingService = this.channelBindingServiceLocator.locateService();
            if (null != this.serverCertificate || null != channelBindingService) {
                LOG.debug((Object)"using server certificate channel binding");
            }
            if (!this.sessionIdChannelBinding && null == this.serverCertificate && null == channelBindingService) {
                LOG.warn((Object)"not using any secure channel binding");
            }
            try {
                challenge = AuthenticationChallenge.getAuthnChallenge(session, this.maxMaturity);
            }
            catch (SecurityException e) {
                AuditService auditService = this.auditServiceLocator.locateService();
                if (null != auditService) {
                    String remoteAddress = request.getRemoteAddr();
                    auditService.authenticationError(remoteAddress, message.authnCert);
                }
                throw new ServletException("security error: " + e.getMessage(), (Throwable)e);
            }
            byte[] serverCertificateClientPOV = null;
            try {
                if (null != message.serverCertificate) {
                    serverCertificateClientPOV = message.serverCertificate.getEncoded();
                }
            }
            catch (CertificateEncodingException e) {
                throw new ServletException("server cert decoding error: " + e.getMessage(), (Throwable)e);
            }
            AuthenticationContract authenticationContract = new AuthenticationContract(message.saltValue, this.hostname, this.inetAddress, message.sessionId, serverCertificateClientPOV, challenge);
            try {
                toBeSigned = authenticationContract.calculateToBeSigned();
            }
            catch (IOException e) {
                throw new ServletException("IO error: " + e.getMessage(), (Throwable)e);
            }
            try {
                Signature signature = Signature.getInstance("SHA1withRSA");
                signature.initVerify(signingKey);
                signature.update(toBeSigned);
                boolean result = signature.verify(signatureValue);
                if (!result) {
                    AuditService auditService = this.auditServiceLocator.locateService();
                    if (null != auditService) {
                        String remoteAddress = request.getRemoteAddr();
                        auditService.authenticationError(remoteAddress, message.authnCert);
                    }
                    throw new SecurityException("authn signature incorrect");
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("algo error");
            }
            catch (InvalidKeyException e) {
                throw new SecurityException("authn key error");
            }
            catch (SignatureException e) {
                throw new SecurityException("signature error");
            }
            if (null != channelBindingService) {
                X509Certificate serverCertificate = channelBindingService.getServerCertificate();
                if (null == serverCertificate) {
                    LOG.warn((Object)"could not verify secure channel binding as the server does not know its identity yet");
                } else {
                    if (!serverCertificate.equals(message.serverCertificate)) {
                        AuditService auditService = this.auditServiceLocator.locateService();
                        if (null != auditService) {
                            String remoteAddress = request.getRemoteAddr();
                            auditService.authenticationError(remoteAddress, message.authnCert);
                        }
                        throw new SecurityException("secure channel binding identity mismatch");
                    }
                    LOG.debug((Object)"secure channel binding verified");
                }
            } else if (null != this.serverCertificate) {
                if (!this.serverCertificate.equals(message.serverCertificate)) {
                    AuditService auditService = this.auditServiceLocator.locateService();
                    if (null != auditService) {
                        String remoteAddress = request.getRemoteAddr();
                        auditService.authenticationError(remoteAddress, message.authnCert);
                    }
                    throw new SecurityException("secure channel binding identity mismatch");
                }
                LOG.debug((Object)"secure channel binding verified");
            }
            AuthenticationService authenticationService = this.authenticationServiceLocator.locateService();
            LinkedList<X509Certificate> certificateChain = new LinkedList<X509Certificate>();
            certificateChain.add(message.authnCert);
            certificateChain.add(message.citizenCaCert);
            certificateChain.add(message.rootCaCert);
            try {
                authenticationService.validateCertificateChain(certificateChain);
            }
            catch (ExpiredCertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE_EXPIRED);
            }
            catch (RevokedCertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE_REVOKED);
            }
            catch (TrustCertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE_NOT_TRUSTED);
            }
            catch (CertificateSecurityException e) {
                return new FinishedMessage(ErrorCode.CERTIFICATE);
            }
            catch (Exception e) {
                Exception exception;
                if (!"javax.ejb.EJBException".equals(e.getClass().getName())) break block60;
                try {
                    Method getCausedByExceptionMethod = e.getClass().getMethod("getCausedByException", new Class[0]);
                    exception = (Exception)getCausedByExceptionMethod.invoke((Object)e, new Object[0]);
                }
                catch (Exception e2) {
                    LOG.debug((Object)("error: " + e.getMessage()), (Throwable)e);
                    throw new SecurityException("error retrieving the root cause: " + e2.getMessage());
                }
                if (exception instanceof ExpiredCertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE_EXPIRED);
                }
                if (exception instanceof RevokedCertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE_REVOKED);
                }
                if (exception instanceof TrustCertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE_NOT_TRUSTED);
                }
                if (exception instanceof CertificateSecurityException) {
                    return new FinishedMessage(ErrorCode.CERTIFICATE);
                }
                throw new SecurityException("authn service error: " + e.getMessage());
            }
        }
        String userId = UserIdentifierUtil.getUserId(message.authnCert);
        if (null != this.nrcidSecret) {
            userId = UserIdentifierUtil.getNonReversibleCitizenIdentifier(userId, this.nrcidOrgId, this.nrcidAppId, this.nrcidSecret);
        }
        session.setAttribute(AUTHENTICATED_USER_IDENTIFIER_SESSION_ATTRIBUTE, (Object)userId);
        EIdData eidData = (EIdData)session.getAttribute("eid");
        if (null == eidData) {
            eidData = new EIdData();
            session.setAttribute("eid", (Object)eidData);
        }
        eidData.identifier = userId;
        AuditService auditService = this.auditServiceLocator.locateService();
        if (null != auditService) {
            auditService.authenticated(userId);
        }
        RequestContext requestContext = new RequestContext(session);
        boolean includeIdentity = requestContext.includeIdentity();
        boolean includeAddress = requestContext.includeAddress();
        boolean includeCertificates = requestContext.includeCertificates();
        boolean includePhoto = requestContext.includePhoto();
        if (includeIdentity && null == message.identityData) {
            throw new ServletException("identity data not included while requested");
        }
        if (includeAddress && null == message.addressData) {
            throw new ServletException("address data not included while requested");
        }
        if (includePhoto && null == message.photoData) {
            throw new ServletException("photo data not included while requested");
        }
        IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
        if (null != identityIntegrityService) {
            if (null == message.rrnCertificate) {
                throw new ServletException("national registry certificate not included while requested");
            }
            LinkedList<X509Certificate> rrnCertificateChain = new LinkedList<X509Certificate>();
            rrnCertificateChain.add(message.rrnCertificate);
            rrnCertificateChain.add(message.rootCaCert);
            identityIntegrityService.checkNationalRegistrationCertificate(rrnCertificateChain);
            PublicKey rrnPublicKey = message.rrnCertificate.getPublicKey();
            if (includeIdentity) {
                if (null == message.identitySignatureData) {
                    throw new ServletException("identity signature data not included while requested");
                }
                this.verifySignature(message.identitySignatureData, rrnPublicKey, request, new byte[][]{message.identityData});
            }
            if (includeAddress) {
                if (null == message.addressSignatureData) {
                    throw new ServletException("address signature data not included while requested");
                }
                byte[] addressFile = this.trimRight(message.addressData);
                this.verifySignature(message.addressSignatureData, rrnPublicKey, request, addressFile, message.identitySignatureData);
            }
        }
        if (includeIdentity) {
            Identity identity = TlvParser.parse(message.identityData, Identity.class);
            if (!UserIdentifierUtil.getUserId(message.authnCert).equals(identity.nationalNumber)) {
                throw new ServletException("national number mismatch");
            }
            session.setAttribute("eid.identity", (Object)identity);
            eidData.identity = identity;
            auditService = this.auditServiceLocator.locateService();
            if (null != auditService) {
                auditService.identified(identity.nationalNumber);
            }
        }
        if (includeAddress) {
            Address address = TlvParser.parse(message.addressData, Address.class);
            session.setAttribute("eid.address", (Object)address);
            eidData.address = address;
        }
        if (includePhoto) {
            byte[] actualPhotoDigest;
            byte[] expectedPhotoDigest;
            if (includeIdentity && !Arrays.equals(expectedPhotoDigest = eidData.identity.photoDigest, actualPhotoDigest = this.digestPhoto(message.photoData))) {
                throw new ServletException("photo digest incorrect");
            }
            session.setAttribute("eid.photo", (Object)message.photoData);
            eidData.photo = message.photoData;
        }
        if (includeCertificates) {
            if (includeIdentity) {
                eidData.certs = new EIdCertsData();
                eidData.certs.authn = message.authnCert;
                eidData.certs.ca = message.citizenCaCert;
                eidData.certs.root = message.rootCaCert;
                eidData.certs.sign = message.signCert;
            }
            session.setAttribute("eid.certs.authn", (Object)message.authnCert);
            session.setAttribute("eid.certs.ca", (Object)message.citizenCaCert);
            session.setAttribute("eid.certs.root", (Object)message.rootCaCert);
            session.setAttribute("eid.certs.sign", (Object)message.signCert);
        }
        return new FinishedMessage();
    }

    private byte[] trimRight(byte[] addressFile) {
        int idx;
        for (idx = 0; idx < addressFile.length && 0 != addressFile[idx]; ++idx) {
        }
        byte[] result = new byte[idx];
        System.arraycopy(addressFile, 0, result, 0, idx);
        return result;
    }

    private byte[] digestPhoto(byte[] photoFile) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1 error: " + e.getMessage(), e);
        }
        byte[] photoDigest = messageDigest.digest(photoFile);
        return photoDigest;
    }

    private void verifySignature(byte[] signatureData, PublicKey publicKey, HttpServletRequest request, byte[] ... data) throws ServletException {
        Signature signature;
        try {
            signature = Signature.getInstance("SHA1withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException("algo error: " + e.getMessage(), (Throwable)e);
        }
        try {
            signature.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new ServletException("key error: " + e.getMessage(), (Throwable)e);
        }
        try {
            for (byte[] dataItem : data) {
                signature.update(dataItem);
            }
            boolean result = signature.verify(signatureData);
            if (!result) {
                AuditService auditService = this.auditServiceLocator.locateService();
                if (null != auditService) {
                    String remoteAddress = request.getRemoteAddr();
                    auditService.identityIntegrityError(remoteAddress);
                }
                throw new ServletException("signature incorrect");
            }
        }
        catch (SignatureException e) {
            throw new ServletException("signature error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkSessionIdChannelBinding(AuthenticationDataMessage message, HttpServletRequest request) {
        LOG.debug((Object)"using TLS session Id channel binding");
        byte[] sessionId = message.sessionId;
        String actualSessionId = (String)request.getAttribute("javax.servlet.request.ssl_session");
        if (null == actualSessionId) {
            actualSessionId = (String)request.getAttribute("javax.servlet.request.ssl_session_id");
        }
        if (null == actualSessionId) {
            LOG.warn((Object)"could not verify the SSL session identifier");
            return;
        }
        if (!Arrays.equals(sessionId, Hex.decode((String)actualSessionId))) {
            LOG.warn((Object)"SSL session Id mismatch");
            LOG.debug((Object)("signed SSL session Id: " + new String(Hex.encode((byte[])sessionId))));
            LOG.debug((Object)("actual SSL session Id: " + actualSessionId));
            throw new SecurityException("SSL session Id mismatch");
        }
        LOG.debug((Object)"SSL session identifier checked");
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        String channelBindingServerCertificate = config.getInitParameter("ChannelBindingServerCertificate");
        if (null != channelBindingServerCertificate) {
            byte[] encodedServerCertificate;
            File serverCertificateFile = new File(channelBindingServerCertificate);
            if (!serverCertificateFile.exists()) {
                throw new ServletException("server certificate not found: " + serverCertificateFile);
            }
            try {
                encodedServerCertificate = FileUtils.readFileToByteArray((File)serverCertificateFile);
            }
            catch (IOException e) {
                throw new ServletException("error reading server certificate: " + e.getMessage(), (Throwable)e);
            }
            this.serverCertificate = this.getCertificate(encodedServerCertificate);
        }
    }

    private X509Certificate getCertificate(byte[] certData) {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("cert factory error: " + e.getMessage(), e);
        }
        try {
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certData));
            return certificate;
        }
        catch (CertificateException e) {
            throw new RuntimeException("certificate decoding error: " + e.getMessage(), e);
        }
    }
}

