/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.Identity;
import be.fedict.eid.applet.service.util.VcardLight;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcardGenerator {
    private static final Log LOG = LogFactory.getLog(VcardGenerator.class);

    public byte[] generateVcard(EIdData eIdData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        VcardLight vcard = new VcardLight(baos);
        vcard.open();
        if (null != eIdData && null != eIdData.getIdentity()) {
            Identity identity = eIdData.getIdentity();
            vcard.addName(identity.firstName, identity.middleName, identity.name);
            if (null != eIdData.getAddress()) {
                Address address = eIdData.getAddress();
                vcard.addAddress(address.streetAndNumber, address.zip, address.municipality);
            } else {
                LOG.debug((Object)"no address");
            }
            vcard.addBorn(identity.dateOfBirth.getTime());
            if (null != eIdData.getPhoto()) {
                byte[] photoData = eIdData.getPhoto();
                vcard.addImage(photoData);
            } else {
                LOG.debug((Object)"no photo");
            }
        }
        vcard.close();
        return baos.toByteArray();
    }
}

