/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.impl.VcardGenerator;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcardServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VcardServlet.class);
    private VcardGenerator vcardGenerator;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.vcardGenerator = new VcardGenerator();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        byte[] document;
        LOG.debug((Object)"doGet");
        HttpSession httpSession = request.getSession();
        EIdData eIdData = (EIdData)httpSession.getAttribute("eid");
        try {
            document = this.vcardGenerator.generateVcard(eIdData);
        }
        catch (IOException e) {
            throw new ServletException("vCard generator error: " + e.getMessage(), (Throwable)e);
        }
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setContentType("text/directory;profile=vCard");
        response.setContentLength(document.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(document);
        out.flush();
    }
}

