/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.impl.KmlGenerator;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KmlServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(KmlServlet.class);
    private KmlGenerator kmlGenerator;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.kmlGenerator = new KmlGenerator();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        byte[] document;
        LOG.debug((Object)"doGet");
        HttpSession httpSession = request.getSession();
        EIdData eIdData = (EIdData)httpSession.getAttribute("eid");
        try {
            document = this.kmlGenerator.generateKml(eIdData);
        }
        catch (IOException e) {
            throw new ServletException("KML generator error: " + e.getMessage(), (Throwable)e);
        }
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=-1");
        if (!request.getScheme().equals("https")) {
            response.setHeader("Pragma", "no-cache");
        } else {
            response.setHeader("Pragma", "public");
        }
        response.setDateHeader("Expires", -1L);
        response.setHeader("Content-disposition", "attachment");
        response.setContentLength(document.length);
        response.setContentType("application/vnd.google-earth.kmz");
        response.setContentLength(document.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(document);
        out.flush();
    }
}

