/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.ooxml;

import be.fedict.eid.applet.service.signer.KeyInfoKeySelector;
import be.fedict.eid.applet.service.signer.ooxml.OOXMLURIDereferencer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOXMLSignatureVerifier {
    private static final Log LOG = LogFactory.getLog(OOXMLSignatureVerifier.class);

    private OOXMLSignatureVerifier() {
    }

    public static boolean isOOXML(URL url) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(url.openStream());
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            return true;
        }
        return false;
    }

    public static List<X509Certificate> getSigners(URL url) throws IOException, ParserConfigurationException, SAXException, TransformerException, MarshalException, XMLSignatureException {
        LinkedList<X509Certificate> signers = new LinkedList<X509Certificate>();
        List<String> signatureResourceNames = OOXMLSignatureVerifier.getSignatureResourceNames(url);
        if (signatureResourceNames.isEmpty()) {
            LOG.debug((Object)"no signature resources");
        }
        for (String signatureResourceName : signatureResourceNames) {
            Document signatureDocument = OOXMLSignatureVerifier.getSignatureDocument(url, signatureResourceName);
            if (null == signatureDocument) continue;
            NodeList signatureNodeList = signatureDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (0 == signatureNodeList.getLength()) {
                return null;
            }
            Node signatureNode = signatureNodeList.item(0);
            KeyInfoKeySelector keySelector = new KeyInfoKeySelector();
            DOMValidateContext domValidateContext = new DOMValidateContext(keySelector, signatureNode);
            domValidateContext.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
            OOXMLURIDereferencer dereferencer = new OOXMLURIDereferencer(url);
            domValidateContext.setURIDereferencer(dereferencer);
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
            XMLSignature xmlSignature = xmlSignatureFactory.unmarshalXMLSignature(domValidateContext);
            boolean validity = xmlSignature.validate(domValidateContext);
            if (!validity) continue;
            X509Certificate signer = keySelector.getCertificate();
            signers.add(signer);
        }
        return signers;
    }

    private static Document getSignatureDocument(URL url, String signatureResourceName) throws IOException, ParserConfigurationException, SAXException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(url.openStream());
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!signatureResourceName.equals(zipEntry.getName())) continue;
            Document signatureDocument = OOXMLSignatureVerifier.loadDocument(zipInputStream);
            return signatureDocument;
        }
        return null;
    }

    private static List<String> getSignatureResourceNames(URL url) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        ZipEntry zipEntry;
        LinkedList<String> signatureResourceNames = new LinkedList<String>();
        InputStream inputStream = url.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            Document contentTypesDocument = OOXMLSignatureVerifier.loadDocument(zipInputStream);
            Element nsElement = contentTypesDocument.createElement("ns");
            nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "http://schemas.openxmlformats.org/package/2006/content-types");
            NodeList nodeList = XPathAPI.selectNodeList((Node)contentTypesDocument, (String)"/tns:Types/tns:Override[@ContentType='application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml']/@PartName", (Node)nsElement);
            for (int nodeIdx = 0; nodeIdx < nodeList.getLength(); ++nodeIdx) {
                String partName = nodeList.item(nodeIdx).getTextContent();
                LOG.debug((Object)("part name: " + partName));
                partName = partName.substring(1);
                signatureResourceNames.add(partName);
            }
        }
        return signatureResourceNames;
    }

    private static Document loadDocument(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(documentInputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }
}

