/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.ooxml;

import be.fedict.eid.applet.service.signer.NoCloseInputStream;
import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.ooxml.AbstractOOXMLSignatureService;
import be.fedict.eid.applet.service.signer.ooxml.RelationshipTransformParameterSpec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOXMLSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(OOXMLSignatureFacet.class);
    private final AbstractOOXMLSignatureService signatureService;

    public OOXMLSignatureFacet(AbstractOOXMLSignatureService signatureService) {
        this.signatureService = signatureService;
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LOG.debug((Object)"pre sign");
        this.addManifestObject(signatureFactory, document, signatureId, references, objects);
        this.addSignatureInfo(signatureFactory, document, signatureId, references, objects);
    }

    private void addManifestObject(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Manifest manifest = this.constructManifest(signatureFactory, document);
        String objectId = "idPackageObject";
        LinkedList<XMLStructure> objectContent = new LinkedList<XMLStructure>();
        objectContent.add(manifest);
        this.addSignatureTime(signatureFactory, document, signatureId, objectContent);
        objects.add(signatureFactory.newXMLObject(objectContent, objectId, null, null));
        DigestMethod digestMethod = signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Reference reference = signatureFactory.newReference("#" + objectId, digestMethod, null, "http://www.w3.org/2000/09/xmldsig#Object", null);
        references.add(reference);
    }

    private Manifest constructManifest(XMLSignatureFactory signatureFactory, Document document) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LinkedList<Reference> manifestReferences = new LinkedList<Reference>();
        try {
            this.addRelationshipsReferences(signatureFactory, document, manifestReferences);
        }
        catch (Exception e) {
            throw new RuntimeException("error: " + e.getMessage(), e);
        }
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.theme+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml", manifestReferences);
        this.addParts(signatureFactory, "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml", manifestReferences);
        Manifest manifest = signatureFactory.newManifest(manifestReferences);
        return manifest;
    }

    private void addSignatureTime(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<XMLStructure> objectContent) {
        Element signatureTimeElement = document.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "mdssi:SignatureTime");
        signatureTimeElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        Element formatElement = document.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "mdssi:Format");
        formatElement.setTextContent("YYYY-MM-DDThh:mm:ssTZD");
        signatureTimeElement.appendChild(formatElement);
        Element valueElement = document.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "mdssi:Value");
        DateTime dateTime = new DateTime(DateTimeZone.UTC);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTimeNoMillis();
        String now = fmt.print((ReadableInstant)dateTime);
        LOG.debug((Object)("now: " + now));
        valueElement.setTextContent(now);
        signatureTimeElement.appendChild(valueElement);
        LinkedList<DOMStructure> signatureTimeContent = new LinkedList<DOMStructure>();
        signatureTimeContent.add(new DOMStructure(signatureTimeElement));
        SignatureProperty signatureTimeSignatureProperty = signatureFactory.newSignatureProperty(signatureTimeContent, "#" + signatureId, "idSignatureTime");
        LinkedList<SignatureProperty> signaturePropertyContent = new LinkedList<SignatureProperty>();
        signaturePropertyContent.add(signatureTimeSignatureProperty);
        SignatureProperties signatureProperties = signatureFactory.newSignatureProperties(signaturePropertyContent, "id-signature-time-" + UUID.randomUUID().toString());
        objectContent.add(signatureProperties);
    }

    private void addSignatureInfo(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LinkedList<SignatureProperties> objectContent = new LinkedList<SignatureProperties>();
        Element signatureInfoElement = document.createElementNS("http://schemas.microsoft.com/office/2006/digsig", "SignatureInfoV1");
        signatureInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.microsoft.com/office/2006/digsig");
        Element manifestHashAlgorithmElement = document.createElementNS("http://schemas.microsoft.com/office/2006/digsig", "ManifestHashAlgorithm");
        manifestHashAlgorithmElement.setTextContent("http://www.w3.org/2000/09/xmldsig#sha1");
        signatureInfoElement.appendChild(manifestHashAlgorithmElement);
        LinkedList<DOMStructure> signatureInfoContent = new LinkedList<DOMStructure>();
        signatureInfoContent.add(new DOMStructure(signatureInfoElement));
        SignatureProperty signatureInfoSignatureProperty = signatureFactory.newSignatureProperty(signatureInfoContent, "#" + signatureId, "idOfficeV1Details");
        LinkedList<SignatureProperty> signaturePropertyContent = new LinkedList<SignatureProperty>();
        signaturePropertyContent.add(signatureInfoSignatureProperty);
        SignatureProperties signatureProperties = signatureFactory.newSignatureProperties(signaturePropertyContent, null);
        objectContent.add(signatureProperties);
        String objectId = "idOfficeObject";
        objects.add(signatureFactory.newXMLObject(objectContent, objectId, null, null));
        DigestMethod digestMethod = signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Reference reference = signatureFactory.newReference("#" + objectId, digestMethod, null, "http://www.w3.org/2000/09/xmldsig#Object", null);
        references.add(reference);
    }

    private void addRelationshipsReferences(XMLSignatureFactory signatureFactory, Document document, List<Reference> manifestReferences) throws IOException, ParserConfigurationException, SAXException, TransformerException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ZipEntry zipEntry;
        URL ooxmlUrl = this.signatureService.getOfficeOpenXMLDocumentURL();
        InputStream inputStream = ooxmlUrl.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!zipEntry.getName().endsWith(".rels")) continue;
            Document relsDocument = this.loadDocumentNoClose(zipInputStream);
            this.addRelationshipsReference(signatureFactory, document, zipEntry.getName(), relsDocument, manifestReferences);
        }
    }

    private void addRelationshipsReference(XMLSignatureFactory signatureFactory, Document document, String zipEntryName, Document relsDocument, List<Reference> manifestReferences) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LOG.debug((Object)("relationships: " + zipEntryName));
        RelationshipTransformParameterSpec parameterSpec = new RelationshipTransformParameterSpec();
        NodeList nodeList = relsDocument.getDocumentElement().getChildNodes();
        for (int nodeIdx = 0; nodeIdx < nodeList.getLength(); ++nodeIdx) {
            Element element;
            String relationshipType;
            Node node = nodeList.item(nodeIdx);
            if (node.getNodeType() != 1 || "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties".equals(relationshipType = (element = (Element)node).getAttribute("Type")) || "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties".equals(relationshipType) || "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin".equals(relationshipType) || "http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail".equals(relationshipType) || "http://schemas.openxmlformats.org/officeDocument/2006/relationships/presProps".equals(relationshipType) || "http://schemas.openxmlformats.org/officeDocument/2006/relationships/viewProps".equals(relationshipType)) continue;
            String relationshipId = element.getAttribute("Id");
            parameterSpec.addRelationshipReference(relationshipId);
        }
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        transforms.add(signatureFactory.newTransform("http://schemas.openxmlformats.org/package/2006/RelationshipTransform", parameterSpec));
        transforms.add(signatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null));
        DigestMethod digestMethod = signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Reference reference = signatureFactory.newReference("/" + zipEntryName + "?ContentType=application/vnd.openxmlformats-package.relationships+xml", digestMethod, transforms, null, null);
        manifestReferences.add(reference);
    }

    private void addParts(XMLSignatureFactory signatureFactory, String contentType, List<Reference> references) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        List<String> documentResourceNames;
        try {
            documentResourceNames = this.getResourceNames(this.signatureService.getOfficeOpenXMLDocumentURL(), contentType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DigestMethod digestMethod = signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        for (String documentResourceName : documentResourceNames) {
            LOG.debug((Object)("document resource: " + documentResourceName));
            Reference reference = signatureFactory.newReference("/" + documentResourceName + "?ContentType=" + contentType, digestMethod);
            references.add(reference);
        }
    }

    private List<String> getResourceNames(URL url, String contentType) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        ZipEntry zipEntry;
        LinkedList<String> signatureResourceNames = new LinkedList<String>();
        if (null == url) {
            throw new RuntimeException("OOXML URL is null");
        }
        InputStream inputStream = url.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            Document contentTypesDocument = this.loadDocument(zipInputStream);
            Element nsElement = contentTypesDocument.createElement("ns");
            nsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", "http://schemas.openxmlformats.org/package/2006/content-types");
            NodeList nodeList = XPathAPI.selectNodeList((Node)contentTypesDocument, (String)("/tns:Types/tns:Override[@ContentType='" + contentType + "']/@PartName"), (Node)nsElement);
            for (int nodeIdx = 0; nodeIdx < nodeList.getLength(); ++nodeIdx) {
                String partName = nodeList.item(nodeIdx).getTextContent();
                LOG.debug((Object)("part name: " + partName));
                partName = partName.substring(1);
                signatureResourceNames.add(partName);
            }
        }
        return signatureResourceNames;
    }

    protected Document loadDocument(String zipEntryName) throws IOException, ParserConfigurationException, SAXException {
        Document document = this.findDocument(zipEntryName);
        if (null != document) {
            return document;
        }
        throw new RuntimeException("ZIP entry not found: " + zipEntryName);
    }

    protected Document findDocument(String zipEntryName) throws IOException, ParserConfigurationException, SAXException {
        ZipEntry zipEntry;
        URL ooxmlUrl = this.signatureService.getOfficeOpenXMLDocumentURL();
        InputStream inputStream = ooxmlUrl.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!zipEntryName.equals(zipEntry.getName())) continue;
            Document document = this.loadDocument(zipInputStream);
            return document;
        }
        return null;
    }

    private Document loadDocumentNoClose(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        NoCloseInputStream noCloseInputStream = new NoCloseInputStream(documentInputStream);
        InputSource inputSource = new InputSource((InputStream)((Object)noCloseInputStream));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    private Document loadDocument(InputStream documentInputStream) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(documentInputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
    }
}

