/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import be.fedict.eid.applet.service.signer.odf.ApacheNodeSetData;
import be.fedict.eid.applet.service.signer.odf.ODFUtil;
import be.fedict.eid.applet.service.signer.odf.ODTEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ODFURIDereferencer
implements URIDereferencer {
    private static final Log LOG = LogFactory.getLog(ODFURIDereferencer.class);
    private final URL odfUrl;
    private final byte[] odfData;
    private final URIDereferencer baseUriDereferener;
    private final DocumentBuilder documentBuilder;

    public ODFURIDereferencer(URL odfUrl) {
        this(odfUrl, null);
    }

    public ODFURIDereferencer(byte[] odfData) {
        this(null, odfData);
    }

    private ODFURIDereferencer(URL odfUrl, byte[] odfData) {
        if (null == odfUrl && null == odfData) {
            throw new IllegalArgumentException("odfUrl and odfData are null");
        }
        if (null != odfUrl && null != odfData) {
            throw new IllegalArgumentException("odfUrl and odfData are both not null");
        }
        this.odfUrl = odfUrl;
        this.odfData = odfData;
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
        this.baseUriDereferener = xmlSignatureFactory.getURIDereferencer();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("parser config error: " + e.getMessage(), e);
        }
        ODTEntityResolver entityResolver = new ODTEntityResolver();
        this.documentBuilder.setEntityResolver(entityResolver);
    }

    public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
        if (null == uriReference) {
            throw new NullPointerException("URIReference cannot be null");
        }
        if (null == context) {
            throw new NullPointerException("XMLCrytoContext cannot be null");
        }
        String uri = uriReference.getURI();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("could not URL decode the uri: " + uri));
        }
        LOG.debug((Object)("dereference: " + uri));
        try {
            InputStream dataInputStream = this.findDataInputStream(uri);
            if (null == dataInputStream) {
                LOG.debug((Object)("cannot resolve, delegating to base DOM URI dereferener: " + uri));
                return this.baseUriDereferener.dereference(uriReference, context);
            }
            if (uri.endsWith(".xml")) {
                byte[] data = IOUtils.toByteArray((InputStream)dataInputStream);
                if (0 == data.length) {
                    return new OctetStreamData(dataInputStream, uri, null);
                }
                Document document = this.documentBuilder.parse(new ByteArrayInputStream(data));
                XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)document);
                ApacheNodeSetData apacheNodeSetData = new ApacheNodeSetData(xmlSignatureInput);
                return apacheNodeSetData;
            }
            return new OctetStreamData(dataInputStream, uri, null);
        }
        catch (IOException e) {
            throw new URIReferenceException("I/O error: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new URIReferenceException("SAX error: " + e.getMessage(), e);
        }
    }

    private InputStream findDataInputStream(String uri) throws IOException {
        InputStream odfInputStream = null != this.odfUrl ? this.odfUrl.openStream() : new ByteArrayInputStream(this.odfData);
        return ODFUtil.findDataInputStream(odfInputStream, uri);
    }
}

