/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.facets;

import be.fedict.eid.applet.service.signer.SignatureFacet;
import be.fedict.eid.applet.service.signer.facets.XAdESNamespacePrefixMapper;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.uri._01903.v1_3.CertIDListType;
import org.etsi.uri._01903.v1_3.CertIDType;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;
import org.etsi.uri._01903.v1_3.SignedPropertiesType;
import org.etsi.uri._01903.v1_3.SignedSignaturePropertiesType;
import org.w3._2000._09.xmldsig_.DigestMethodType;
import org.w3._2000._09.xmldsig_.ObjectFactory;
import org.w3._2000._09.xmldsig_.X509IssuerSerialType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAdESSignatureFacet
implements SignatureFacet {
    private static final Log LOG = LogFactory.getLog(XAdESSignatureFacet.class);
    private static final String XADES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    private final DatatypeFactory datatypeFactory;
    private final org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory;
    private final ObjectFactory xmldsigObjectFactory;
    private final Marshaller marshaller;

    public XAdESSignatureFacet() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("datatype config error: " + e.getMessage(), e);
        }
        this.xadesObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
        this.xmldsigObjectFactory = new ObjectFactory();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{org.etsi.uri._01903.v1_3.ObjectFactory.class});
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new XAdESNamespacePrefixMapper());
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
    }

    @Override
    public void postSign(Element signatureElement, List<X509Certificate> signingCertificateChain) {
        LOG.debug((Object)"postSign");
    }

    @Override
    public void preSign(XMLSignatureFactory signatureFactory, Document document, String signatureId, List<X509Certificate> signingCertificateChain, List<Reference> references, List<XMLObject> objects) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        byte[] digestValue;
        LOG.debug((Object)"preSign");
        QualifyingPropertiesType qualifyingProperties = this.xadesObjectFactory.createQualifyingPropertiesType();
        qualifyingProperties.setTarget("#" + signatureId);
        SignedPropertiesType signedProperties = this.xadesObjectFactory.createSignedPropertiesType();
        String signedPropertiesId = signatureId + "-xades";
        signedProperties.setId(signedPropertiesId);
        qualifyingProperties.setSignedProperties(signedProperties);
        SignedSignaturePropertiesType signedSignatureProperties = this.xadesObjectFactory.createSignedSignaturePropertiesType();
        signedProperties.setSignedSignatureProperties(signedSignatureProperties);
        GregorianCalendar signingTime = new GregorianCalendar();
        signingTime.setTimeZone(TimeZone.getTimeZone("Z"));
        signedSignatureProperties.setSigningTime(this.datatypeFactory.newXMLGregorianCalendar(signingTime));
        CertIDListType signingCertificates = this.xadesObjectFactory.createCertIDListType();
        CertIDType signingCertificateId = this.xadesObjectFactory.createCertIDType();
        X509IssuerSerialType issuerSerial = this.xmldsigObjectFactory.createX509IssuerSerialType();
        if (null == signingCertificateChain || signingCertificateChain.isEmpty()) {
            throw new RuntimeException("no signing certificate chain available");
        }
        X509Certificate signingCertificate = signingCertificateChain.get(0);
        issuerSerial.setX509IssuerName(signingCertificate.getIssuerX500Principal().toString());
        issuerSerial.setX509SerialNumber(signingCertificate.getSerialNumber());
        signingCertificateId.setIssuerSerial(issuerSerial);
        DigestAlgAndValueType certDigest = this.xadesObjectFactory.createDigestAlgAndValueType();
        DigestMethodType jaxbDigestMethod = this.xmldsigObjectFactory.createDigestMethodType();
        jaxbDigestMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        certDigest.setDigestMethod(jaxbDigestMethod);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        try {
            digestValue = messageDigest.digest(signingCertificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("certificate encoding error: " + e.getMessage(), e);
        }
        certDigest.setDigestValue(digestValue);
        signingCertificateId.setCertDigest(certDigest);
        signingCertificates.getCert().add(signingCertificateId);
        signedSignatureProperties.setSigningCertificate(signingCertificates);
        Node qualifyingPropertiesNode = this.marshallQualifyingProperties(document, this.xadesObjectFactory, qualifyingProperties);
        LinkedList<DOMStructure> xadesObjectContent = new LinkedList<DOMStructure>();
        xadesObjectContent.add(new DOMStructure(qualifyingPropertiesNode));
        XMLObject xadesObject = signatureFactory.newXMLObject(xadesObjectContent, null, null, null);
        objects.add(xadesObject);
        DigestMethod digestMethod = signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        Transform exclusiveTransform = signatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        transforms.add(exclusiveTransform);
        Reference reference = signatureFactory.newReference("#" + signedPropertiesId, digestMethod, transforms, XADES_TYPE, null);
        references.add(reference);
    }

    private Node marshallQualifyingProperties(Document document, org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory, QualifyingPropertiesType qualifyingProperties) {
        Element marshallNode = document.createElement("marshall-node");
        try {
            this.marshaller.marshal(xadesObjectFactory.createQualifyingProperties(qualifyingProperties), (Node)marshallNode);
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB error: " + e.getMessage(), e);
        }
        Node qualifyingPropertiesNode = marshallNode.getFirstChild();
        return qualifyingPropertiesNode;
    }
}

