/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.io;

import be.fedict.eid.applet.shared.protocol.HttpTransmitter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;

public class HttpURLConnectionHttpTransmitter
implements HttpTransmitter {
    private final HttpURLConnection connection;

    public HttpURLConnectionHttpTransmitter(HttpURLConnection connection, String userAgent) {
        this.connection = connection;
        this.connection.setUseCaches(false);
        this.connection.setAllowUserInteraction(false);
        this.connection.setRequestProperty("Content-Type", "application/octet-stream");
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        try {
            this.connection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new RuntimeException("protocol error: " + e.getMessage(), e);
        }
        if (userAgent != null) {
            this.connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    public void addHeader(String headerName, String headerValue) {
        this.connection.setRequestProperty(headerName, headerValue);
    }

    public void setBody(byte[] bodyValue) {
        try {
            OutputStream connectionOutputStream = this.connection.getOutputStream();
            connectionOutputStream.write(bodyValue);
            connectionOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("error: " + e.getMessage(), e);
        }
    }

    public boolean isSecure() {
        if ("localhost".equals(this.connection.getURL().getHost())) {
            return true;
        }
        return false != "https".equals(this.connection.getURL().getProtocol());
    }
}

