/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.UserIdentifierUtil;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.spi.AuditService;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.SignatureDataMessage;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesMessage(value=SignatureDataMessage.class)
public class SignatureDataMessageHandler
implements MessageHandler<SignatureDataMessage> {
    private static final Log LOG = LogFactory.getLog(SignatureDataMessageHandler.class);
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="AuditService")
    private ServiceLocator<AuditService> auditServiceLocator;
    public static final String DIGEST_VALUE_SESSION_ATTRIBUTE = SignatureDataMessageHandler.class.getName() + ".digestValue";

    @Override
    public Object handleMessage(SignatureDataMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        AuditService auditService;
        byte[] signatureDigestValue;
        LOG.debug((Object)"signature data message received");
        byte[] signatureValue = message.signatureValue;
        List certificateChain = message.certificateChain;
        if (certificateChain.isEmpty()) {
            throw new ServletException("certificate chain is empty");
        }
        X509Certificate signingCertificate = (X509Certificate)certificateChain.get(0);
        if (null == signingCertificate) {
            throw new ServletException("non-repudiation certificate missing");
        }
        LOG.debug((Object)("non-repudiation signing certificate: " + signingCertificate.getSubjectX500Principal()));
        PublicKey signingPublicKey = signingCertificate.getPublicKey();
        byte[] expectedDigestValue = SignatureDataMessageHandler.getDigestValue(session);
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, signingPublicKey);
            byte[] signatureDigestInfoValue = cipher.doFinal(signatureValue);
            ASN1InputStream aIn = new ASN1InputStream(signatureDigestInfoValue);
            DigestInfo signatureDigestInfo = new DigestInfo((ASN1Sequence)aIn.readObject());
            signatureDigestValue = signatureDigestInfo.getDigest();
        }
        catch (Exception e) {
            LOG.debug((Object)("signature verification error: " + e.getMessage()));
            throw new ServletException("signature verification error: " + e.getMessage(), (Throwable)e);
        }
        if (!Arrays.areEqual((byte[])expectedDigestValue, (byte[])signatureDigestValue)) {
            auditService = this.auditServiceLocator.locateService();
            if (null != auditService) {
                String remoteAddress = request.getRemoteAddr();
                auditService.signatureError(remoteAddress, signingCertificate);
            }
            throw new ServletException("signature incorrect");
        }
        auditService = this.auditServiceLocator.locateService();
        if (null != auditService) {
            String userId = UserIdentifierUtil.getUserId(signingCertificate);
            auditService.signed(userId);
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        signatureService.postSign(signatureValue, certificateChain);
        return new FinishedMessage();
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
    }

    public static byte[] getDigestValue(HttpSession session) {
        return (byte[])session.getAttribute(DIGEST_VALUE_SESSION_ATTRIBUTE);
    }

    public static void setDigestValue(byte[] digestValue, HttpSession session) {
        session.setAttribute(DIGEST_VALUE_SESSION_ATTRIBUTE, (Object)digestValue);
    }
}

