/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.AuthenticationChallenge;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.service.spi.AuthenticationService;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityIntegrityService;
import be.fedict.eid.applet.service.spi.PrivacyService;
import be.fedict.eid.applet.service.spi.SecureClientEnvironmentService;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.shared.AdministrationMessage;
import be.fedict.eid.applet.shared.AuthenticationRequestMessage;
import be.fedict.eid.applet.shared.CheckClientMessage;
import be.fedict.eid.applet.shared.DiagnosticMessage;
import be.fedict.eid.applet.shared.FilesDigestRequestMessage;
import be.fedict.eid.applet.shared.HelloMessage;
import be.fedict.eid.applet.shared.IdentificationRequestMessage;
import be.fedict.eid.applet.shared.KioskMessage;
import be.fedict.eid.applet.shared.SignCertificatesRequestMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesMessage(value=HelloMessage.class)
public class HelloMessageHandler
implements MessageHandler<HelloMessage> {
    private static final Log LOG = LogFactory.getLog(HelloMessageHandler.class);
    public static final String INCLUDE_IDENTITY_INIT_PARAM_NAME = "IncludeIdentity";
    public static final String INCLUDE_PHOTO_INIT_PARAM_NAME = "IncludePhoto";
    public static final String INCLUDE_CERTS_INIT_PARAM_NAME = "IncludeCertificates";
    public static final String INCLUDE_ADDRESS_INIT_PARAM_NAME = "IncludeAddress";
    public static final String SECURE_CLIENT_ENV_SERVICE_INIT_PARAM_NAME = "SecureClientEnvironmentService";
    public static final String IDENTITY_INTEGRITY_SERVICE_INIT_PARAM_NAME = "IdentityIntegrityService";
    public static final String SIGNATURE_SERVICE_INIT_PARAM_NAME = "SignatureService";
    public static final String PRIVACY_SERVICE_INIT_PARAM_NAME = "PrivacyService";
    public static final String REMOVE_CARD_INIT_PARAM_NAME = "RemoveCard";
    public static final String HOSTNAME_INIT_PARAM_NAME = "Hostname";
    public static final String INET_ADDRESS_INIT_PARAM_NAME = "InetAddress";
    public static final String CHANGE_PIN_INIT_PARAM_NAME = "ChangePin";
    public static final String UNBLOCK_PIN_INIT_PARAM_NAME = "UnblockPin";
    public static final String LOGOFF_INIT_PARAM_NAME = "Logoff";
    public static final String PRE_LOGOFF_INIT_PARAM_NAME = "PreLogoff";
    public static final String KIOSK_INIT_PARAM_NAME = "Kiosk";
    public static final String SESSION_ID_CHANNEL_BINDING_INIT_PARAM_NAME = "SessionIdChannelBinding";
    public static final String CHANNEL_BINDING_SERVER_CERTIFICATE = "ChannelBindingServerCertificate";
    public static final String CHANNEL_BINDING_SERVICE = "ChannelBindingService";
    public static final String REQUIRE_SECURE_READER_INIT_PARAM_NAME = "RequireSecureReader";
    public static final String DIAGNOSTIC_MODE_INIT_PARAM_NAME = "DiagnosticMode";
    public static final String NO_PKCS11_INIT_PARAM_NAME = "NoPKCS11";
    @InitParam(value="IncludePhoto")
    private boolean includePhoto;
    @InitParam(value="IncludeAddress")
    private boolean includeAddress;
    @InitParam(value="IncludeIdentity")
    private boolean includeIdentity;
    @InitParam(value="RemoveCard")
    private boolean removeCard;
    private boolean includeHostname;
    private boolean includeInetAddress;
    @InitParam(value="ChangePin")
    private boolean changePin;
    @InitParam(value="UnblockPin")
    private boolean unblockPin;
    @InitParam(value="Logoff")
    private boolean logoff;
    @InitParam(value="PreLogoff")
    private boolean preLogoff;
    @InitParam(value="IncludeCertificates")
    private boolean includeCertificates;
    @InitParam(value="Kiosk")
    private boolean kiosk;
    @InitParam(value="SessionIdChannelBinding")
    private boolean sessionIdChannelBinding;
    private boolean serverCertificateChannelBinding;
    @InitParam(value="RequireSecureReader")
    private boolean requireSecureReader;
    @InitParam(value="DiagnosticMode")
    private boolean diagnosticMode;
    @InitParam(value="SecureClientEnvironmentService")
    private ServiceLocator<SecureClientEnvironmentService> secureClientEnvServiceLocator;
    @InitParam(value="IdentityIntegrityService")
    private ServiceLocator<IdentityIntegrityService> identityIntegrityServiceLocator;
    @InitParam(value="AuthenticationService")
    private ServiceLocator<AuthenticationService> authenticationServiceLocator;
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="PrivacyService")
    private ServiceLocator<PrivacyService> privacyServiceLocator;
    @InitParam(value="NoPKCS11")
    private boolean noPkcs11;
    private static final String CLIENT_LANGUAGE_SESSION_ATTRIBUTE = HelloMessageHandler.class.getName() + ".clientLanguage";

    @Override
    public Object handleMessage(HelloMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        LOG.debug((Object)"hello message received");
        this.storeClientLanguage(message.language, session);
        if (this.diagnosticMode) {
            LOG.debug((Object)"diagnostic mode");
            DiagnosticMessage diagnosticMessage = new DiagnosticMessage();
            return diagnosticMessage;
        }
        SecureClientEnvironmentService secureClientEnvService = this.secureClientEnvServiceLocator.locateService();
        if (null != secureClientEnvService) {
            CheckClientMessage checkClientMessage = new CheckClientMessage();
            return checkClientMessage;
        }
        if (this.kiosk) {
            LOG.debug((Object)"operating in Kiosk Mode");
            KioskMessage kioskMessage = new KioskMessage();
            return kioskMessage;
        }
        if (this.changePin || this.unblockPin) {
            AdministrationMessage administrationMessage = new AdministrationMessage(this.changePin, this.unblockPin, this.logoff, this.removeCard, this.requireSecureReader);
            return administrationMessage;
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        if (null != signatureService) {
            DigestInfo digestInfo;
            String filesDigestAlgo = signatureService.getFilesDigestAlgorithm();
            if (null != filesDigestAlgo) {
                LOG.debug((Object)("files digest algo: " + filesDigestAlgo));
                FilesDigestRequestMessage filesDigestRequestMessage = new FilesDigestRequestMessage();
                filesDigestRequestMessage.digestAlgo = filesDigestAlgo;
                return filesDigestRequestMessage;
            }
            if (this.includeCertificates) {
                LOG.debug((Object)"include signing certificate chain during pre-sign");
                IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
                boolean includeIntegrityData = null != identityIntegrityService;
                SignCertificatesRequestMessage signCertificatesRequestMessage = new SignCertificatesRequestMessage(this.includeIdentity, this.includeAddress, this.includePhoto, includeIntegrityData);
                return signCertificatesRequestMessage;
            }
            try {
                digestInfo = signatureService.preSign(null, null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException("no such algo: " + e.getMessage(), (Throwable)e);
            }
            SignatureDataMessageHandler.setDigestValue(digestInfo.digestValue, session);
            SignRequestMessage signRequestMessage = new SignRequestMessage(digestInfo.digestValue, digestInfo.digestAlgo, digestInfo.description, this.logoff, this.removeCard, this.requireSecureReader, this.noPkcs11);
            return signRequestMessage;
        }
        AuthenticationService authenticationService = this.authenticationServiceLocator.locateService();
        if (null != authenticationService) {
            byte[] challenge = AuthenticationChallenge.generateChallenge(session);
            IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
            boolean includeIntegrityData = null != identityIntegrityService;
            AuthenticationRequestMessage authenticationRequestMessage = new AuthenticationRequestMessage(challenge, this.includeHostname, this.includeInetAddress, this.logoff, this.preLogoff, this.removeCard, this.sessionIdChannelBinding, this.serverCertificateChannelBinding, this.includeIdentity, this.includeCertificates, this.includeAddress, this.includePhoto, includeIntegrityData, this.requireSecureReader, this.noPkcs11);
            return authenticationRequestMessage;
        }
        IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
        boolean includeIntegrityData = null != identityIntegrityService;
        PrivacyService privacyService = this.privacyServiceLocator.locateService();
        String identityDataUsage = null != privacyService ? privacyService.getIdentityDataUsage(message.language) : null;
        IdentificationRequestMessage responseMessage = new IdentificationRequestMessage(this.includeAddress, this.includePhoto, includeIntegrityData, this.includeCertificates, this.removeCard, identityDataUsage);
        return responseMessage;
    }

    private void storeClientLanguage(String language, HttpSession httpSession) {
        httpSession.setAttribute(CLIENT_LANGUAGE_SESSION_ATTRIBUTE, (Object)language);
    }

    public static String getClientLanguage(HttpSession httpSession) {
        String clientLanguage = (String)httpSession.getAttribute(CLIENT_LANGUAGE_SESSION_ATTRIBUTE);
        return clientLanguage;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        String channelBindingService;
        String channelBindingServerCertificate;
        String inetAddress;
        String hostname = config.getInitParameter(HOSTNAME_INIT_PARAM_NAME);
        if (null != hostname) {
            this.includeHostname = true;
        }
        if (null != (inetAddress = config.getInitParameter(INET_ADDRESS_INIT_PARAM_NAME))) {
            this.includeInetAddress = true;
        }
        if (null != (channelBindingServerCertificate = config.getInitParameter(CHANNEL_BINDING_SERVER_CERTIFICATE))) {
            this.serverCertificateChannelBinding = true;
        }
        if (null != (channelBindingService = config.getInitParameter(CHANNEL_BINDING_SERVICE))) {
            this.serverCertificateChannelBinding = true;
        }
    }
}

