/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl.handler;

import be.fedict.eid.applet.service.impl.AuthenticationChallenge;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.HelloMessageHandler;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.service.spi.AuthenticationService;
import be.fedict.eid.applet.service.spi.DigestInfo;
import be.fedict.eid.applet.service.spi.IdentityIntegrityService;
import be.fedict.eid.applet.service.spi.PrivacyService;
import be.fedict.eid.applet.service.spi.SignatureService;
import be.fedict.eid.applet.shared.AdministrationMessage;
import be.fedict.eid.applet.shared.AuthenticationRequestMessage;
import be.fedict.eid.applet.shared.ContinueInsecureMessage;
import be.fedict.eid.applet.shared.FilesDigestRequestMessage;
import be.fedict.eid.applet.shared.IdentificationRequestMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesMessage(value=ContinueInsecureMessage.class)
public class ContinueInsecureMessageHandler
implements MessageHandler<ContinueInsecureMessage> {
    private static final Log LOG = LogFactory.getLog(ContinueInsecureMessageHandler.class);
    @InitParam(value="IncludePhoto")
    private boolean includePhoto;
    @InitParam(value="IncludeAddress")
    private boolean includeAddress;
    @InitParam(value="IncludeIdentity")
    private boolean includeIdentity;
    private boolean includeInetAddress;
    @InitParam(value="IdentityIntegrityService")
    private ServiceLocator<IdentityIntegrityService> identityIntegrityServiceLocator;
    @InitParam(value="AuthenticationService")
    private ServiceLocator<AuthenticationService> authenticationServiceLocator;
    @InitParam(value="PrivacyService")
    private ServiceLocator<PrivacyService> privacyServiceLocator;
    private SecureRandom secureRandom;
    @InitParam(value="RemoveCard")
    private boolean removeCard;
    @InitParam(value="ChangePin")
    private boolean changePin;
    @InitParam(value="UnblockPin")
    private boolean unblockPin;
    private boolean includeHostname;
    @InitParam(value="Logoff")
    private boolean logoff;
    @InitParam(value="PreLogoff")
    private boolean preLogoff;
    @InitParam(value="IncludeCertificates")
    private boolean includeCertificates;
    @InitParam(value="SessionIdChannelBinding")
    private boolean sessionIdChannelBinding;
    private boolean serverCertificateChannelBinding;
    @InitParam(value="RequireSecureReader")
    private boolean requireSecureReader;
    @InitParam(value="SignatureService")
    private ServiceLocator<SignatureService> signatureServiceLocator;
    @InitParam(value="NoPKCS11")
    private boolean noPkcs11;

    @Override
    public Object handleMessage(ContinueInsecureMessage message, Map<String, String> httpHeaders, HttpServletRequest request, HttpSession session) throws ServletException {
        String identityDataUsage;
        if (this.changePin || this.unblockPin) {
            AdministrationMessage administrationMessage = new AdministrationMessage(this.changePin, this.unblockPin, this.logoff, this.removeCard, this.requireSecureReader);
            return administrationMessage;
        }
        SignatureService signatureService = this.signatureServiceLocator.locateService();
        if (null != signatureService) {
            DigestInfo digestInfo;
            String filesDigestAlgo = signatureService.getFilesDigestAlgorithm();
            if (null != filesDigestAlgo) {
                LOG.debug((Object)("files digest algo: " + filesDigestAlgo));
                FilesDigestRequestMessage filesDigestRequestMessage = new FilesDigestRequestMessage();
                filesDigestRequestMessage.digestAlgo = filesDigestAlgo;
                return filesDigestRequestMessage;
            }
            try {
                digestInfo = signatureService.preSign(null, null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException("no such algo: " + e.getMessage(), (Throwable)e);
            }
            SignatureDataMessageHandler.setDigestValue(digestInfo.digestValue, session);
            SignRequestMessage signRequestMessage = new SignRequestMessage(digestInfo.digestValue, digestInfo.digestAlgo, digestInfo.description, this.logoff, this.removeCard, this.requireSecureReader, this.noPkcs11);
            return signRequestMessage;
        }
        AuthenticationService authenticationService = this.authenticationServiceLocator.locateService();
        if (null != authenticationService) {
            byte[] challenge = AuthenticationChallenge.generateChallenge(session);
            IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
            boolean includeIntegrityData = null != identityIntegrityService;
            AuthenticationRequestMessage authenticationRequestMessage = new AuthenticationRequestMessage(challenge, this.includeHostname, this.includeInetAddress, this.logoff, this.preLogoff, this.removeCard, this.sessionIdChannelBinding, this.serverCertificateChannelBinding, this.includeIdentity, this.includeCertificates, this.includeAddress, this.includePhoto, includeIntegrityData, this.requireSecureReader, this.noPkcs11);
            return authenticationRequestMessage;
        }
        IdentityIntegrityService identityIntegrityService = this.identityIntegrityServiceLocator.locateService();
        boolean includeIntegrityData = null != identityIntegrityService;
        PrivacyService privacyService = this.privacyServiceLocator.locateService();
        if (null != privacyService) {
            String clientLanguage = HelloMessageHandler.getClientLanguage(session);
            identityDataUsage = privacyService.getIdentityDataUsage(clientLanguage);
        } else {
            identityDataUsage = null;
        }
        IdentificationRequestMessage responseMessage = new IdentificationRequestMessage(this.includeAddress, this.includePhoto, includeIntegrityData, this.includeCertificates, this.removeCard, identityDataUsage);
        return responseMessage;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        String channelBindingService;
        String channelBindingServerCertificate;
        String inetAddress;
        this.secureRandom = new SecureRandom();
        this.secureRandom.setSeed(System.currentTimeMillis());
        String hostname = config.getInitParameter("Hostname");
        if (null != hostname) {
            this.includeHostname = true;
        }
        if (null != (inetAddress = config.getInitParameter("InetAddress"))) {
            this.includeInetAddress = true;
        }
        if (null != (channelBindingServerCertificate = config.getInitParameter("ChannelBindingServerCertificate"))) {
            this.serverCertificateChannelBinding = true;
        }
        if (null != (channelBindingService = config.getInitParameter("ChannelBindingService"))) {
            this.serverCertificateChannelBinding = true;
        }
    }
}

