/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.shared.protocol.ProtocolState;
import be.fedict.eid.applet.shared.protocol.ProtocolStateListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CleanSessionProtocolStateListener
implements ProtocolStateListener {
    private static final Log LOG = LogFactory.getLog(CleanSessionProtocolStateListener.class);
    private final HttpSession httpSession;

    public CleanSessionProtocolStateListener(HttpServletRequest request) {
        this.httpSession = request.getSession();
    }

    public void protocolStateTransition(ProtocolState newProtocolState) {
        switch (newProtocolState) {
            case IDENTIFY: {
                LOG.debug((Object)"cleaning up the identity session attributes...");
                this.httpSession.removeAttribute("eid.identity");
                this.httpSession.removeAttribute("eid.address");
                this.httpSession.removeAttribute("eid.photo");
                this.httpSession.removeAttribute("eid.certs");
                EIdData eidData = (EIdData)this.httpSession.getAttribute("eid");
                if (null == eidData) break;
                eidData.identity = null;
                eidData.address = null;
                eidData.photo = null;
                eidData.certs = null;
                break;
            }
            case AUTHENTICATE: {
                LOG.debug((Object)"cleaning up the authn session attributes...");
                this.httpSession.removeAttribute("eid.identifier");
                this.httpSession.removeAttribute("eid.identity");
                this.httpSession.removeAttribute("eid.address");
                this.httpSession.removeAttribute("eid.photo");
                EIdData eidData = (EIdData)this.httpSession.getAttribute("eid");
                if (null == eidData) break;
                eidData.identifier = null;
                eidData.identity = null;
                eidData.address = null;
                eidData.photo = null;
                eidData.certs = null;
                break;
            }
        }
    }
}

