/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.impl.CleanSessionProtocolStateListener;
import be.fedict.eid.applet.service.impl.HttpServletProtocolContext;
import be.fedict.eid.applet.service.impl.HttpServletRequestHttpReceiver;
import be.fedict.eid.applet.service.impl.HttpServletResponseHttpTransmitter;
import be.fedict.eid.applet.service.impl.ServiceLocator;
import be.fedict.eid.applet.service.impl.handler.AuthenticationDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.ClientEnvironmentMessageHandler;
import be.fedict.eid.applet.service.impl.handler.ContinueInsecureMessageHandler;
import be.fedict.eid.applet.service.impl.handler.FileDigestsDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.HandlesMessage;
import be.fedict.eid.applet.service.impl.handler.HelloMessageHandler;
import be.fedict.eid.applet.service.impl.handler.IdentityDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.InitParam;
import be.fedict.eid.applet.service.impl.handler.MessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignCertificatesDataMessageHandler;
import be.fedict.eid.applet.service.impl.handler.SignatureDataMessageHandler;
import be.fedict.eid.applet.shared.AbstractProtocolMessage;
import be.fedict.eid.applet.shared.AppletProtocolMessageCatalog;
import be.fedict.eid.applet.shared.annotation.ResponsesAllowed;
import be.fedict.eid.applet.shared.protocol.HttpReceiver;
import be.fedict.eid.applet.shared.protocol.HttpTransmitter;
import be.fedict.eid.applet.shared.protocol.ProtocolContext;
import be.fedict.eid.applet.shared.protocol.ProtocolMessageCatalog;
import be.fedict.eid.applet.shared.protocol.ProtocolStateListener;
import be.fedict.eid.applet.shared.protocol.ProtocolStateMachine;
import be.fedict.eid.applet.shared.protocol.Transport;
import be.fedict.eid.applet.shared.protocol.Unmarshaller;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(AppletServiceServlet.class);
    private static final Class<? extends MessageHandler<?>>[] MESSAGE_HANDLER_CLASSES = new Class[]{IdentityDataMessageHandler.class, HelloMessageHandler.class, ClientEnvironmentMessageHandler.class, AuthenticationDataMessageHandler.class, SignatureDataMessageHandler.class, FileDigestsDataMessageHandler.class, ContinueInsecureMessageHandler.class, SignCertificatesDataMessageHandler.class};
    private Map<Class<?>, MessageHandler<?>> messageHandlers;
    private Unmarshaller unmarshaller;
    private static final String SKIP_SECURE_CONNECTION_CHECK_INIT_PARAM = "SkipSecureConnectionCheck";
    private boolean skipSecureConnectionCheck;

    public AppletServiceServlet() {
        LOG.debug((Object)"constructor");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LOG.debug((Object)"init");
        this.messageHandlers = new HashMap();
        for (Class<MessageHandler<?>> clazz : MESSAGE_HANDLER_CLASSES) {
            MessageHandler<?> messageHandler;
            HandlesMessage handlesMessageAnnotation = clazz.getAnnotation(HandlesMessage.class);
            if (null == handlesMessageAnnotation) {
                throw new ServletException("missing meta-data on message handler: " + clazz.getName());
            }
            Class<? extends AbstractProtocolMessage> protocolMessageClass = handlesMessageAnnotation.value();
            try {
                messageHandler = clazz.newInstance();
            }
            catch (Exception e) {
                throw new ServletException("cannot create message handler instance");
            }
            this.messageHandlers.put(protocolMessageClass, messageHandler);
        }
        Collection<MessageHandler<?>> messageHandlers = this.messageHandlers.values();
        for (MessageHandler<?> messageHandler : messageHandlers) {
            try {
                AppletServiceServlet.injectInitParams(config, messageHandler);
            }
            catch (Exception exception) {
                throw new ServletException("error injecting init-param into message handler field: " + exception.getMessage(), (Throwable)exception);
            }
            messageHandler.init(config);
        }
        this.unmarshaller = new Unmarshaller((ProtocolMessageCatalog)new AppletProtocolMessageCatalog());
        String skipSecureConnectionCheck = config.getInitParameter(SKIP_SECURE_CONNECTION_CHECK_INIT_PARAM);
        if (null != skipSecureConnectionCheck) {
            this.skipSecureConnectionCheck = Boolean.parseBoolean(skipSecureConnectionCheck);
            LOG.debug((Object)("skipping secure connection check: " + this.skipSecureConnectionCheck));
        }
    }

    public static void injectInitParams(ServletConfig config, MessageHandler<?> messageHandler) throws ServletException, IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Class<?> messageHandlerClass = messageHandler.getClass();
        for (Field field : fields = messageHandlerClass.getDeclaredFields()) {
            Comparable<Boolean> fieldValue;
            InitParam initParamAnnotation = field.getAnnotation(InitParam.class);
            if (null == initParamAnnotation) continue;
            String initParamName = initParamAnnotation.value();
            Class<?> fieldType = field.getType();
            field.setAccessible(true);
            if (ServiceLocator.class.equals(fieldType)) {
                ServiceLocator fieldValue2 = new ServiceLocator(initParamName, config);
                field.set(messageHandler, fieldValue2);
                continue;
            }
            String initParamValue = config.getInitParameter(initParamName);
            if (initParamAnnotation.required() && null == initParamValue) {
                throw new ServletException("missing required init-param: " + initParamName + " for message handler:" + messageHandlerClass.getName());
            }
            if (null == initParamValue) continue;
            if (Boolean.TYPE.equals(fieldType)) {
                LOG.debug((Object)("injecting boolean: " + initParamValue));
                fieldValue = Boolean.parseBoolean(initParamValue);
                field.set(messageHandler, fieldValue);
                continue;
            }
            if (String.class.equals(fieldType)) {
                field.set(messageHandler, initParamValue);
                continue;
            }
            if (InetAddress.class.equals(fieldType)) {
                InetAddress inetAddress;
                try {
                    inetAddress = InetAddress.getByName(initParamValue);
                }
                catch (UnknownHostException e) {
                    throw new ServletException("unknown host: " + initParamValue);
                }
                field.set(messageHandler, inetAddress);
                continue;
            }
            if (Long.class.equals(fieldType)) {
                fieldValue = Long.parseLong(initParamValue);
                field.set(messageHandler, fieldValue);
                continue;
            }
            throw new ServletException("unsupported init-param field type: " + fieldType.getName());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug((Object)"doGet");
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>eID Applet Service</title></head>");
        out.println("<body>");
        out.println("<h1>eID Applet Service</h1>");
        out.println("<p>The eID Applet Service should not be accessed directly.</p>");
        out.println("</body></html>");
        out.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object transferObject;
        LOG.debug((Object)"doPost");
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        Enumeration headerNamesEnum = request.getHeaderNames();
        while (headerNamesEnum.hasMoreElements()) {
            String headerName = (String)headerNamesEnum.nextElement();
            httpHeaders.put(headerName, request.getHeader(headerName));
        }
        HttpServletRequestHttpReceiver httpReceiver = new HttpServletRequestHttpReceiver(request, this.skipSecureConnectionCheck);
        try {
            transferObject = this.unmarshaller.receive((HttpReceiver)httpReceiver);
        }
        catch (Exception e) {
            LOG.debug((Object)("unmarshaller error: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("unmarshaller error: " + e.getMessage(), e);
        }
        HttpServletProtocolContext protocolContext = new HttpServletProtocolContext(request);
        ProtocolStateMachine protocolStateMachine = new ProtocolStateMachine((ProtocolContext)protocolContext);
        CleanSessionProtocolStateListener cleanSessionProtocolStateListener = new CleanSessionProtocolStateListener(request);
        protocolStateMachine.addProtocolStateListener((ProtocolStateListener)cleanSessionProtocolStateListener);
        protocolStateMachine.checkRequestMessage(transferObject);
        Class<?> messageClass = transferObject.getClass();
        MessageHandler<?> messageHandler = this.messageHandlers.get(messageClass);
        if (null == messageHandler) {
            throw new ServletException("unsupported message");
        }
        HttpSession session = request.getSession();
        Object responseMessage = messageHandler.handleMessage(transferObject, httpHeaders, request, session);
        ResponsesAllowed responsesAllowedAnnotation = messageClass.getAnnotation(ResponsesAllowed.class);
        if (null != responsesAllowedAnnotation) {
            if (null == responseMessage) {
                throw new ServletException("null response message while @ResponsesAllowed constraint was set");
            }
            Class[] responsesAllowed = responsesAllowedAnnotation.value();
            if (!this.isOfClass(responseMessage, responsesAllowed)) {
                throw new ServletException("response message type incorrect");
            }
        }
        protocolStateMachine.checkResponseMessage(responseMessage);
        if (null != responseMessage) {
            HttpServletResponseHttpTransmitter httpTransmitter = new HttpServletResponseHttpTransmitter(response);
            Transport.transfer((Object)responseMessage, (HttpTransmitter)httpTransmitter);
        }
    }

    private boolean isOfClass(Object object, Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.equals(object.getClass())) continue;
            return true;
        }
        return false;
    }
}

