/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.signer.odf;

import be.fedict.eid.applet.service.signer.KeyInfoKeySelector;
import be.fedict.eid.applet.service.signer.odf.ODFURIDereferencer;
import be.fedict.eid.applet.service.signer.odf.ODFUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODFSignatureVerifier {
    private static final Log LOG = LogFactory.getLog(ODFSignatureVerifier.class);

    private ODFSignatureVerifier() {
    }

    public static boolean hasOdfSignature(URL odfUrl) throws IOException, ParserConfigurationException, SAXException, XMLSignatureException, XMLSecurityException, MarshalException, javax.xml.crypto.dsig.XMLSignatureException {
        List<X509Certificate> signers = ODFSignatureVerifier.getSigners(odfUrl);
        return false == signers.isEmpty();
    }

    public static List<X509Certificate> getSigners(URL odfUrl) throws IOException, ParserConfigurationException, SAXException, MarshalException, javax.xml.crypto.dsig.XMLSignatureException {
        ZipEntry zipEntry;
        LinkedList<X509Certificate> signers = new LinkedList<X509Certificate>();
        if (null == odfUrl) {
            throw new IllegalArgumentException("odfUrl is null");
        }
        ZipInputStream odfZipInputStream = new ZipInputStream(odfUrl.openStream());
        while (null != (zipEntry = odfZipInputStream.getNextEntry())) {
            if (!ODFUtil.isSignatureFile(zipEntry)) continue;
            Document documentSignatures = ODFUtil.loadDocument(odfZipInputStream);
            NodeList signatureNodeList = documentSignatures.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            for (int idx = 0; idx < signatureNodeList.getLength(); ++idx) {
                Node signatureNode = signatureNodeList.item(idx);
                X509Certificate signer = ODFSignatureVerifier.getVerifiedSignatureSigner(odfUrl, signatureNode);
                if (null == signer) {
                    LOG.debug((Object)"JSR105 says invalid signature");
                    continue;
                }
                signers.add(signer);
            }
            return signers;
        }
        LOG.debug((Object)"no signature file present");
        return signers;
    }

    private static X509Certificate getVerifiedSignatureSigner(URL odfUrl, Node signatureNode) throws MarshalException, javax.xml.crypto.dsig.XMLSignatureException {
        if (null == odfUrl) {
            throw new IllegalArgumentException("odfUrl is null");
        }
        KeyInfoKeySelector keySelector = new KeyInfoKeySelector();
        DOMValidateContext domValidateContext = new DOMValidateContext(keySelector, signatureNode);
        ODFURIDereferencer dereferencer = new ODFURIDereferencer(odfUrl);
        domValidateContext.setURIDereferencer(dereferencer);
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
        LOG.debug((Object)("java version: " + System.getProperty("java.version")));
        XMLSignature xmlSignature = xmlSignatureFactory.unmarshalXMLSignature(domValidateContext);
        boolean validity = xmlSignature.validate(domValidateContext);
        if (!validity) {
            LOG.debug((Object)"invalid signature");
            return null;
        }
        X509Certificate signer = keySelector.getCertificate();
        if (null == signer) {
            throw new IllegalStateException("signer X509 certificate is null");
        }
        LOG.debug((Object)("signer: " + signer.getSubjectX500Principal()));
        return signer;
    }

    public static boolean isODF(URL url) throws IOException {
        InputStream resStream = ODFUtil.findDataInputStream(url.openStream(), ODFUtil.MIMETYPE_FILE);
        if (null == resStream) {
            LOG.debug((Object)"mimetype stream not found in ODF package");
            return false;
        }
        String mimetypeContent = IOUtils.toString((InputStream)resStream);
        return mimetypeContent.startsWith(ODFUtil.MIMETYPE_START);
    }
}

