/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import be.fedict.eid.applet.shared.protocol.HttpReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletRequestHttpReceiver
implements HttpReceiver {
    private final HttpServletRequest httpServletRequest;
    private final boolean skipSecureConnectionCheck;

    public HttpServletRequestHttpReceiver(HttpServletRequest httpServletRequest, boolean skipSecureConnectionCheck) {
        this.httpServletRequest = httpServletRequest;
        this.skipSecureConnectionCheck = skipSecureConnectionCheck;
    }

    public byte[] getBody() {
        try {
            ServletInputStream inputStream = this.httpServletRequest.getInputStream();
            byte[] body = IOUtils.toByteArray((InputStream)inputStream);
            return body;
        }
        catch (IOException e) {
            throw new RuntimeException("IO error: " + e.getMessage(), e);
        }
    }

    public List<String> getHeaderNames() {
        Enumeration headerNamesEnumeration = this.httpServletRequest.getHeaderNames();
        LinkedList<String> headerNames = new LinkedList<String>();
        while (headerNamesEnumeration.hasMoreElements()) {
            String headerName = (String)headerNamesEnumeration.nextElement();
            headerNames.add(headerName);
        }
        return headerNames;
    }

    public String getHeaderValue(String headerName) {
        return this.httpServletRequest.getHeader(headerName);
    }

    public boolean isSecure() {
        if (this.skipSecureConnectionCheck) {
            return true;
        }
        return false != this.httpServletRequest.isSecure();
    }
}

