/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class AuthenticationContract {
    private final byte[] salt;
    private final String hostname;
    private final InetAddress inetAddress;
    public static final String LEGAL_NOTICE = "Declaration of authentication intension.\nThe following data should be interpreted as an authentication challenge.\n";
    private final byte[] sessionId;
    private final byte[] encodedServerCertificate;
    private final byte[] challenge;

    public AuthenticationContract(byte[] salt, String hostname, InetAddress inetAddress, byte[] sessionId, byte[] encodedServerCertificate, byte[] challenge) {
        this.salt = salt;
        this.hostname = hostname;
        this.inetAddress = inetAddress;
        this.sessionId = sessionId;
        this.encodedServerCertificate = encodedServerCertificate;
        this.challenge = challenge;
    }

    public byte[] calculateToBeSigned() throws IOException {
        ByteArrayOutputStream toBeSignedOutputStream = new ByteArrayOutputStream();
        toBeSignedOutputStream.write(this.salt);
        if (null != this.hostname) {
            toBeSignedOutputStream.write(this.hostname.getBytes());
        }
        if (null != this.inetAddress) {
            byte[] address = this.inetAddress.getAddress();
            toBeSignedOutputStream.write(address);
        }
        toBeSignedOutputStream.write(LEGAL_NOTICE.getBytes());
        if (null != this.sessionId) {
            toBeSignedOutputStream.write(this.sessionId);
        }
        if (null != this.encodedServerCertificate) {
            toBeSignedOutputStream.write(this.encodedServerCertificate);
        }
        toBeSignedOutputStream.write(this.challenge);
        byte[] toBeSigned = toBeSignedOutputStream.toByteArray();
        return toBeSigned;
    }
}

