/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.infinispan.atomic.Operation;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=47)
public class PutOperation<K, V>
extends Operation<K, V> {
    private K key;
    private V oldValue;
    private V newValue;

    public PutOperation() {
    }

    PutOperation(K key, V oldValue, V newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (this.oldValue == null) {
            delegate.remove(this.key);
        } else {
            delegate.put(this.key, this.oldValue);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.put(this.key, this.newValue);
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            PutOperation put = (PutOperation)object;
            output.writeObject(put.key);
            output.writeObject(put.newValue);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            PutOperation put = new PutOperation();
            put.key = input.readObject();
            put.newValue = input.readObject();
            return put;
        }
    }
}

