/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.aop.impl.concurrency.bridge;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import org.jboss.ejb3.metadata.MetaDataBridge;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.AccessTimeoutMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;

public class AccessTimeoutMetaDataBridge
implements MetaDataBridge<JBossEnterpriseBeanMetaData> {
    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData metaData, ClassLoader classLoader) {
        if (annotationClass == null || !annotationClass.equals(AccessTimeout.class)) {
            return null;
        }
        if (!metaData.isSession() || !(metaData instanceof JBossSessionBean31MetaData)) {
            return null;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)metaData;
        AccessTimeoutMetaData accessTimeoutMetaData = sessionBean.getAccessTimeout();
        if (accessTimeoutMetaData == null) {
            return null;
        }
        AccessTimeoutImpl accessTimeout = new AccessTimeoutImpl(accessTimeoutMetaData.getTimeout(), accessTimeoutMetaData.getUnit());
        return (A)((Annotation)annotationClass.cast(accessTimeout));
    }

    public <A extends Annotation> A retrieveAnnotation(Class<A> annotationClass, JBossEnterpriseBeanMetaData metaData, ClassLoader classLoader, DeclaredMethodSignature method) {
        ConcurrentMethodsMetaData concurrentMethods;
        if (annotationClass == null || !annotationClass.equals(AccessTimeout.class)) {
            return null;
        }
        if (!metaData.isSession() || !(metaData instanceof JBossSessionBean31MetaData)) {
            return null;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)metaData;
        NamedMethodMetaData namedMethod = new NamedMethodMetaData();
        namedMethod.setName(method.getName());
        if (method.getParameters() != null) {
            MethodParametersMetaData methodParams = new MethodParametersMetaData();
            methodParams.addAll(Arrays.asList(method.getParameters()));
            namedMethod.setMethodParams(methodParams);
        }
        if ((concurrentMethods = sessionBean.getConcurrentMethods()) == null) {
            return null;
        }
        ConcurrentMethodMetaData concurrentMethodMetaData = concurrentMethods.find(namedMethod);
        AccessTimeoutMetaData accessTimeoutMetaData = null;
        if (concurrentMethodMetaData == null || concurrentMethodMetaData.getAccessTimeout() == null) {
            accessTimeoutMetaData = this.getAccessTimeoutApplicableForAllMethods(sessionBean);
        }
        if (accessTimeoutMetaData == null) {
            return null;
        }
        AccessTimeoutImpl accessTimeout = new AccessTimeoutImpl(accessTimeoutMetaData.getTimeout(), accessTimeoutMetaData.getUnit());
        return (A)((Annotation)annotationClass.cast(accessTimeout));
    }

    private AccessTimeoutMetaData getAccessTimeoutApplicableForAllMethods(JBossSessionBean31MetaData sessionBean) {
        NamedMethodMetaData allMethods = new NamedMethodMetaData();
        allMethods.setName("*");
        ConcurrentMethodMetaData concurrentMethod = sessionBean.getConcurrentMethods().get(allMethods);
        if (concurrentMethod == null) {
            return null;
        }
        return concurrentMethod.getAccessTimeout();
    }

    private class AccessTimeoutImpl
    implements AccessTimeout {
        private TimeUnit unit;
        private long timeout;
        private final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;

        public AccessTimeoutImpl(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.unit = unit;
        }

        public TimeUnit unit() {
            return this.unit == null ? this.DEFAULT_TIME_UNIT : this.unit;
        }

        public long value() {
            return this.timeout;
        }

        public Class<? extends Annotation> annotationType() {
            return AccessTimeout.class;
        }
    }
}

