/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.TcpAcceptor;
import org.jboss.xnio.TcpChannelDestination;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioTcpChannel;
import org.jboss.xnio.nio.NioXnio;

final class NioTcpAcceptor
implements TcpAcceptor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.acceptor");
    private final NioXnio nioXnio;
    private final Executor executor;
    private final OptionMap optionMap;

    private NioTcpAcceptor(NioXnio nioXnio, Executor executor, OptionMap optionMap) {
        if (nioXnio == null) {
            throw new NullPointerException("nioXnio is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.nioXnio = nioXnio;
        this.executor = executor;
        this.optionMap = optionMap;
    }

    static NioTcpAcceptor create(NioXnio nioXnio, Executor executor, OptionMap optionMap) {
        return new NioTcpAcceptor(nioXnio, executor, optionMap);
    }

    public IoFuture<TcpChannel> acceptTo(InetSocketAddress dest, ChannelListener<? super TcpChannel> handler, ChannelListener<? super BoundChannel<InetSocketAddress>> bindListener) {
        try {
            BoundChannel<InetSocketAddress> boundChannel;
            AtomicReference<Object> listenerReference;
            final ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            final ServerSocket serverSocket = serverSocketChannel.socket();
            OptionMap optionMap = this.optionMap;
            if (optionMap.contains(Options.RECEIVE_BUFFER)) {
                serverSocket.setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, 0));
            }
            serverSocket.setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
            serverSocket.bind(dest, 1);
            if (bindListener != null) {
                listenerReference = new AtomicReference<Object>(null);
                boundChannel = new BoundChannel<InetSocketAddress>(){

                    public InetSocketAddress getLocalAddress() {
                        return (InetSocketAddress)serverSocket.getLocalSocketAddress();
                    }

                    public ChannelListener.Setter<? extends BoundChannel<InetSocketAddress>> getCloseSetter() {
                        return IoUtils.getSetter((AtomicReference)listenerReference);
                    }

                    public boolean isOpen() {
                        return serverSocketChannel.isOpen();
                    }

                    public void close() throws IOException {
                        serverSocketChannel.close();
                    }

                    public boolean supportsOption(Option<?> option) {
                        return false;
                    }

                    public <T> T getOption(Option<T> option) throws IOException {
                        return null;
                    }

                    public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                        return this;
                    }
                };
                IoUtils.invokeChannelListener((Executor)this.executor, (Channel)boundChannel, bindListener);
            } else {
                listenerReference = null;
                boundChannel = null;
            }
            Handler nioHandler = new Handler(serverSocketChannel, handler, listenerReference, boundChannel);
            NioHandle handle = this.nioXnio.addConnectHandler(serverSocketChannel, nioHandler, true);
            nioHandler.handle = handle;
            handle.resume(16);
            return nioHandler.futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    public TcpChannelDestination createChannelDestination(final InetSocketAddress dest) {
        return new TcpChannelDestination(){

            public IoFuture<TcpChannel> accept(ChannelListener<? super TcpChannel> openListener, ChannelListener<? super BoundChannel<InetSocketAddress>> bindListener) {
                return NioTcpAcceptor.this.acceptTo(dest, openListener, bindListener);
            }
        };
    }

    public String toString() {
        return String.format("TCP acceptor (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private final class Handler
    implements Runnable {
        private final FutureResult<TcpChannel> futureResult;
        private final ServerSocketChannel serverSocketChannel;
        private final ChannelListener<? super TcpChannel> openListener;
        private final AtomicReference<ChannelListener<? super BoundChannel<InetSocketAddress>>> listenerReference;
        private final BoundChannel<InetSocketAddress> boundChannel;
        private volatile NioHandle handle;

        public Handler(ServerSocketChannel serverSocketChannel, ChannelListener<? super TcpChannel> openListener, AtomicReference<ChannelListener<? super BoundChannel<InetSocketAddress>>> listenerReference, BoundChannel<InetSocketAddress> boundChannel) {
            this.serverSocketChannel = serverSocketChannel;
            this.openListener = openListener;
            this.listenerReference = listenerReference;
            this.boundChannel = boundChannel;
            this.futureResult = new FutureResult(NioTcpAcceptor.this.executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocketChannel serverSocketChannel = this.serverSocketChannel;
            try {
                boolean ok = false;
                SocketChannel socketChannel = serverSocketChannel.accept();
                if (socketChannel == null) {
                    this.handle.resume(16);
                    return;
                }
                try {
                    ChannelListener<? super BoundChannel<InetSocketAddress>> closeListener;
                    IoUtils.safeClose((Closeable)serverSocketChannel);
                    if (this.listenerReference != null && (closeListener = this.listenerReference.get()) != null) {
                        IoUtils.invokeChannelListener(this.boundChannel, closeListener);
                    }
                    socketChannel.configureBlocking(false);
                    Socket socket = socketChannel.socket();
                    OptionMap optionMap = NioTcpAcceptor.this.optionMap;
                    if (optionMap.contains(Options.KEEP_ALIVE)) {
                        socket.setKeepAlive((Boolean)optionMap.get(Options.KEEP_ALIVE));
                    }
                    if (optionMap.contains(Options.TCP_OOB_INLINE)) {
                        socket.setOOBInline((Boolean)optionMap.get(Options.TCP_OOB_INLINE));
                    }
                    if (optionMap.contains(Options.TCP_NODELAY)) {
                        socket.setTcpNoDelay((Boolean)optionMap.get(Options.TCP_NODELAY));
                    }
                    NioXnio nioXnio = NioTcpAcceptor.this.nioXnio;
                    NioTcpChannel channel = new NioTcpChannel(nioXnio, socketChannel, NioTcpAcceptor.this.executor, optionMap.get(Options.MANAGE_CONNECTIONS, true), (InetSocketAddress)socket.getLocalSocketAddress(), (InetSocketAddress)socket.getRemoteSocketAddress());
                    ok = true;
                    nioXnio.addManaged(channel);
                    IoUtils.invokeChannelListener((Channel)((Object)channel), this.openListener);
                    this.futureResult.setResult((Object)channel);
                }
                finally {
                    if (!ok) {
                        log.trace("TCP server failed to accept connection");
                        IoUtils.safeClose((Closeable)serverSocketChannel);
                        IoUtils.safeClose((Closeable)socketChannel);
                    }
                }
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)serverSocketChannel);
                this.futureResult.setException(e);
            }
        }
    }
}

