/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins.system;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.classloader.plugins.system.DefaultClassLoaderSystem;
import org.jboss.classloader.spi.ClassLoaderSystem;

public class ClassLoaderSystemBuilder {
    private static final ClassLoaderSystem singleton = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderSystem>(){

        @Override
        public ClassLoaderSystem run() {
            String className = System.getProperty(ClassLoaderSystem.class.getName(), DefaultClassLoaderSystem.class.getName());
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                Object result = clazz.newInstance();
                return (ClassLoaderSystem)ClassLoaderSystem.class.cast(result);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("Unexpected error loading ClassLoaderSystem " + className, e);
            }
        }
    });

    public static ClassLoaderSystem get() {
        return singleton;
    }
}

