/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.handler.session.stateful;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.proxy.clustered.invocation.InvokableContextClusteredProxyInvocationHandler;
import org.jboss.ejb3.proxy.impl.handler.session.SessionRemoteProxyInvocationHandler;
import org.jboss.ejb3.proxy.spi.container.InvokableContext;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.remoting.InvokerLocator;

public class StatefulClusteredProxyInvocationHandler
extends SessionRemoteProxyInvocationHandler {
    private static final long serialVersionUID = 8941906289390905059L;
    private FamilyWrapper family;
    private LoadBalancePolicy lbPolicy;
    private String partitionName;
    private final InvokableContext container;

    public StatefulClusteredProxyInvocationHandler(String containerName, String containerGuid, Interceptor[] interceptors, String businessInterfaceType, Object target, String url, FamilyWrapper family, LoadBalancePolicy lb, String partitionName) {
        super(containerName, containerGuid, interceptors, businessInterfaceType, target, url);
        InvokableContext container;
        assert (family != null) : "family is null";
        assert (lb != null) : "lb is null";
        assert (partitionName != null) : "partitionName is null";
        this.family = family;
        this.lbPolicy = lb;
        this.partitionName = partitionName;
        InvokerLocator locator = null;
        try {
            locator = new InvokerLocator(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create " + InvokerLocator.class.getSimpleName() + " to url \"" + url + "\"", e);
        }
        Interceptor[] resolvedInterceptors = this.getInterceptors();
        assert (containerName != null && containerName.trim().length() > 0) : "Container Name must be set";
        InvokableContextClusteredProxyInvocationHandler handler = new InvokableContextClusteredProxyInvocationHandler(this.getContainerName(), this.getContainerGuid(), locator, resolvedInterceptors, (Serializable)this.getTarget(), this.getFamilyWrapper(), this.getLoadBalancePolicy(), this.getPartitionName(), true);
        Class[] interfaces = new Class[]{InvokableContext.class};
        this.container = container = (InvokableContext)Proxy.newProxyInstance(InvokableContext.class.getClassLoader(), interfaces, (InvocationHandler)((Object)handler));
    }

    protected InvokableContext getContainer(Method method, Object[] args) {
        return this.container;
    }

    public FamilyWrapper getFamilyWrapper() {
        return this.family;
    }

    public LoadBalancePolicy getLoadBalancePolicy() {
        return this.lbPolicy;
    }

    public String getPartitionName() {
        return this.partitionName;
    }
}

