/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.ejb3.metamodel.ApplicationException;
import org.jboss.ejb3.metamodel.ContainerTransaction;
import org.jboss.ejb3.metamodel.ExcludeList;
import org.jboss.ejb3.metamodel.InitList;
import org.jboss.ejb3.metamodel.Inject;
import org.jboss.ejb3.metamodel.InterceptorBinding;
import org.jboss.ejb3.metamodel.MessageDestination;
import org.jboss.ejb3.metamodel.MethodPermission;
import org.jboss.logging.Logger;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metamodel.descriptor.SecurityRole;

public class AssemblyDescriptor {
    private static final Logger log = Logger.getLogger(AssemblyDescriptor.class);
    private List securityRoles = new ArrayList();
    private Map<String, SecurityRoleMetaData> securityRoleMetaData = new HashMap<String, SecurityRoleMetaData>();
    private List methodPermissions = new ArrayList();
    private List containerTransactions = new ArrayList();
    private HashMap<String, MessageDestination> messageDestinations = new HashMap();
    private ExcludeList excludeList;
    private List applicationExceptions = new ArrayList();
    private InitList initList;
    private List injects = new ArrayList();
    private List interceptorBindings = new ArrayList();

    public Collection<MessageDestination> getMessageDestinations() {
        return this.messageDestinations.values();
    }

    public void addMessageDestination(MessageDestination messageDestination) {
        this.messageDestinations.put(messageDestination.getMessageDestinationName(), messageDestination);
    }

    public MessageDestination findMessageDestination(String name) {
        return this.messageDestinations.get(name);
    }

    public InitList getInitList() {
        return this.initList;
    }

    public void setInitList(InitList initList) {
        this.initList = initList;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    public void setExcludeList(ExcludeList excludeList) {
        this.excludeList = excludeList;
    }

    public List getApplicationExceptions() {
        return this.applicationExceptions;
    }

    public void addApplicationException(ApplicationException applicationException) {
        this.applicationExceptions.add(applicationException);
    }

    public List getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(List securityRoles) {
        this.securityRoles = securityRoles;
    }

    public void addSecurityRole(SecurityRole securityRole) {
        this.securityRoles.add(securityRole);
    }

    public List<InterceptorBinding> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public void addInterceptorBinding(InterceptorBinding binding) {
        this.interceptorBindings.add(binding);
    }

    public List getInjects() {
        return this.injects;
    }

    public void addInject(Inject inject) {
        this.injects.add(inject);
    }

    public List getMethodPermissions() {
        return this.methodPermissions;
    }

    public void setMethodPermissions(List methodPermissions) {
        this.methodPermissions = methodPermissions;
    }

    public void addMethodPermission(MethodPermission methodPermission) {
        this.methodPermissions.add(methodPermission);
    }

    public List getContainerTransactions() {
        return this.containerTransactions;
    }

    public void setContainerTransactions(List containerTransactions) {
        this.containerTransactions = containerTransactions;
    }

    public void addContainerTransaction(ContainerTransaction containerTransaction) {
        this.containerTransactions.add(containerTransaction);
    }

    public void addSecurityRoleMetaData(SecurityRoleMetaData srm) {
        this.securityRoleMetaData.put(srm.getRoleName(), srm);
    }

    public Set getSecurityRolesGivenPrincipal(String userName) {
        HashSet<String> roleNames = new HashSet<String>();
        for (SecurityRoleMetaData srMetaData : this.securityRoleMetaData.values()) {
            if (!srMetaData.getPrincipals().contains(userName)) continue;
            roleNames.add(srMetaData.getRoleName());
        }
        return roleNames;
    }

    public Map getPrincipalVersusRolesMap() {
        HashMap principalRolesMap = null;
        Iterator<String> iter = this.securityRoleMetaData.keySet().iterator();
        while (iter.hasNext()) {
            if (principalRolesMap == null) {
                principalRolesMap = new HashMap();
            }
            String rolename = iter.next();
            SecurityRoleMetaData srm = this.securityRoleMetaData.get(rolename);
            for (String pr : srm.getPrincipals()) {
                HashSet<String> roleset = (HashSet<String>)principalRolesMap.get(pr);
                if (roleset == null) {
                    roleset = new HashSet<String>();
                }
                if (!roleset.contains(rolename)) {
                    roleset.add(rolename);
                }
                principalRolesMap.put(pr, roleset);
            }
        }
        return principalRolesMap;
    }

    public Map<String, SecurityRoleMetaData> getSecurityRoleMetaData() {
        return this.securityRoleMetaData;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[");
        sb.append("securityRoles=").append(this.securityRoles);
        sb.append(", applicationExceptions=").append(this.applicationExceptions);
        sb.append("]");
        return sb.toString();
    }
}

