/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hierarchy.plugins;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.scanning.hierarchy.spi.HierarchyIndex;
import org.jboss.scanning.plugins.helpers.MergeUtils;
import org.jboss.scanning.plugins.helpers.WeakClassLoaderHolder;
import org.jboss.scanning.spi.ScanningHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyIndexImpl
extends WeakClassLoaderHolder
implements HierarchyIndex,
ScanningHandle<HierarchyIndexImpl>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Map<String, Map<TypeInfo, Set<TypeInfo>>> cache = new HashMap<String, Map<TypeInfo, Set<TypeInfo>>>();
    private transient TypeInfoFactory tif;

    public HierarchyIndexImpl() {
    }

    public HierarchyIndexImpl(ClassLoader classLoader) {
        super(classLoader);
    }

    protected ClassLoader getClassLoader() {
        return super.getClassLoader();
    }

    void cleanup() {
        this.cache.clear();
    }

    Map<String, Map<TypeInfo, Set<TypeInfo>>> getCache() {
        return this.cache;
    }

    public void merge(HierarchyIndexImpl subHandle) {
        if (this.tif == null) {
            this.tif = subHandle.tif;
        }
        MergeUtils.doubleMerge(this.cache, subHandle.getCache());
    }

    void putInfo(String path, TypeInfo key, TypeInfo ... classes) {
        Map<TypeInfo, Set<TypeInfo>> map;
        if (this.tif == null) {
            this.tif = key.getTypeInfoFactory();
        }
        if ((map = this.cache.get(path)) == null) {
            map = new HashMap<TypeInfo, Set<TypeInfo>>();
            this.cache.put(path, map);
        }
        for (TypeInfo superType : classes) {
            Set<TypeInfo> infos = map.get(superType);
            if (infos == null) {
                infos = new HashSet<TypeInfo>();
                map.put(superType, infos);
            }
            infos.add(key);
        }
    }

    @Override
    public Set<TypeInfo> getSubTypesOf(URL url, TypeInfo superTypeToLookFor) {
        Set<TypeInfo> result = null;
        if (url == null) {
            Collection<Map<TypeInfo, Set<TypeInfo>>> mappings = this.cache.values();
            for (Map<TypeInfo, Set<TypeInfo>> m : mappings) {
                Set<TypeInfo> tmp = m.get(superTypeToLookFor);
                if (tmp == null) continue;
                if (result == null) {
                    result = new HashSet<TypeInfo>();
                }
                result.addAll(tmp);
            }
        } else {
            String path = url.getPath();
            Map<TypeInfo, Set<TypeInfo>> map = this.cache.get(HierarchyIndexImpl.fixPath(path));
            if (map != null) {
                result = map.get(superTypeToLookFor);
            }
        }
        return result == null || result.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(result);
    }

    @Override
    public Set<TypeInfo> getSubTypesOf(URL url, Class<?> superTypeToLookFor) {
        if (this.tif == null) {
            return Collections.emptySet();
        }
        return this.getSubTypesOf(url, this.tif.getTypeInfo(superTypeToLookFor));
    }

    @Override
    public <T> Set<Class<? extends T>> getSubClassesOf(URL url, Class<T> superTypeToLookFor) {
        Set<TypeInfo> classes = this.getSubTypesOf(url, superTypeToLookFor);
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (TypeInfo ti : classes) {
            Class clazz = ti.getType();
            result.add(clazz);
        }
        return result;
    }

    static String fixPath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
        this.tif = new IntrospectionTypeInfoFactory();
    }
}

