/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.hornetq.core.persistence.StorageManager;

public abstract class AbstractControl
extends StandardMBean {
    protected final StorageManager storageManager;

    public AbstractControl(Class<?> clazz, StorageManager storageManager) throws NotCompliantMBeanException {
        super(clazz);
        this.storageManager = storageManager;
    }

    protected void clearIO() {
        if (this.storageManager != null) {
            this.storageManager.clearContext();
        }
    }

    protected void blockOnIO() {
        if (this.storageManager != null) {
            try {
                this.storageManager.waitOnOperations();
                this.storageManager.clearContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    abstract MBeanOperationInfo[] fillMBeanOperationInfo();

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), this.fillMBeanOperationInfo(), info.getNotifications());
    }
}

