/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.api.as.server.JBossASBasedServer;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.api.descriptor.UrlBootstrapDescriptor;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.api.mc.server.MCBasedServer;
import org.jboss.bootstrap.impl.as.config.JBossASBasedConfigurationValidator;
import org.jboss.bootstrap.impl.as.config.JBossASConfigurationInitializerImpl;
import org.jboss.bootstrap.impl.as.lifecycle.KernelStartEventLifecycleEventHandler;
import org.jboss.bootstrap.impl.as.lifecycle.KernelStopEventLifecycleEventHandler;
import org.jboss.bootstrap.impl.as.server.ASVersion;
import org.jboss.bootstrap.impl.as.server.JBossASServerInitializer;
import org.jboss.bootstrap.impl.as.xml.BootstrapParser;
import org.jboss.bootstrap.impl.base.config.InvalidBootstrapURLException;
import org.jboss.bootstrap.impl.mc.server.AbstractMCServerBase;
import org.jboss.bootstrap.spi.as.metadata.BootstrapMetaData;
import org.jboss.bootstrap.spi.as.server.MCJBossASBasedServerProvider;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;

@ManagementObject(name="jboss.system:type=MCServer", isRuntime=true, properties=ManagementProperties.EXPLICIT, description="the MCServer bootstrap view", componentType=@ManagementComponent(type="MCBean", subtype="*"))
public abstract class AbstractJBossASServerBase<K extends JBossASBasedServer<K, T>, T extends JBossASBasedServerConfig<T>>
extends AbstractMCServerBase<K, T>
implements MCJBossASBasedServerProvider<K, T> {
    private static final Logger log = Logger.getLogger(AbstractJBossASServerBase.class);
    public static final String NAME_MANAGEMENT_OBJECT = "jboss.system:type=MCServer";
    private static final char CHAR_ENV_VAR = '$';
    private static final char CHAR_NEWLINE = '\n';
    private static final char CHAR_TAB = '\t';
    private static final String SLASH = "/";
    private final ASVersion version = ASVersion.getInstance();
    private volatile Date startDate;
    private final Map<String, Object> metadata = new ConcurrentHashMap<String, Object>();

    public AbstractJBossASServerBase(Class<K> actualClass) throws IllegalArgumentException {
        this(actualClass, null);
    }

    public AbstractJBossASServerBase(Class<K> actualClass, T config) throws IllegalArgumentException {
        super(actualClass, config);
        this.setValidator(new JBossASBasedConfigurationValidator());
        this.setServerInitializer(new JBossASServerInitializer());
        this.setConfigInitializer((ConfigurationInitializer)new JBossASConfigurationInitializerImpl());
    }

    @ManagementProperty(description="The server build date", readOnly=true)
    public String getBuildDate() {
        return this.version.getBuildDate();
    }

    @ManagementProperty(description="The server build ID", readOnly=true)
    public String getBuildID() {
        return this.version.getBuildID();
    }

    @ManagementProperty(description="The server build JVM", readOnly=true)
    public String getBuildJVM() {
        return this.version.getBuildJVM();
    }

    @ManagementProperty(description="The server build number", readOnly=true)
    public String getBuildNumber() {
        return this.version.getBuildNumber();
    }

    @ManagementProperty(description="The server build OS", readOnly=true)
    public String getBuildOS() {
        return this.version.getBuildOS();
    }

    @ManagementProperty(description="The server start time", readOnly=true)
    public Date getStartDate() {
        Date copyDate = (Date)this.startDate.clone();
        return copyDate;
    }

    @ManagementProperty(description="The server version string", readOnly=true)
    public String getVersion() {
        return this.version.toString();
    }

    @ManagementProperty(description="The server version name", readOnly=true)
    public String getVersionName() {
        return this.version.getName();
    }

    @ManagementProperty(description="The server version number string", readOnly=true)
    public String getVersionNumber() {
        return this.version.getVersionNumber();
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @Deprecated
    public boolean isStarted() {
        LifecycleState state = this.getState();
        return state.equals((Object)LifecycleState.STARTED);
    }

    protected void doInitialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        super.doInitialize();
        this.setupBootstrapDescriptorsFromBootstrapUrl();
        KernelStartEventLifecycleEventHandler startHandler = new KernelStartEventLifecycleEventHandler((MCBasedServer<?, ?>)this);
        KernelStopEventLifecycleEventHandler stopHandler = new KernelStopEventLifecycleEventHandler((MCBasedServer<?, ?>)this);
        this.registerEventHandler(startHandler, new LifecycleState[]{LifecycleState.STARTED});
        this.registerEventHandler(stopHandler, new LifecycleState[]{LifecycleState.STOPPING});
        this.logServerInfo();
    }

    protected void logServerInfo() {
        StringBuilder sb = new StringBuilder();
        int newline = 10;
        int tab = 9;
        JBossASBasedServerConfig config = (JBossASBasedServerConfig)this.getConfiguration();
        if (config.getJBossHome() != null) {
            String jbossHome = config.getJBossHome().toExternalForm();
            sb.append("Server Configuration:");
            sb.append('\n').append('\n').append('\t');
            sb.append("JBOSS_HOME URL: " + jbossHome);
            sb.append('\n').append('\t');
            sb.append("Bootstrap: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getBootstrapUrl()));
            sb.append('\n').append('\t');
            sb.append("Common Base: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getCommonBaseLocation()));
            sb.append('\n').append('\t');
            sb.append("Common Library: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getCommonLibLocation()));
            sb.append('\n').append('\t');
            sb.append("Server Name: " + config.getServerName());
            sb.append('\n').append('\t');
            sb.append("Server Base: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getServerBaseLocation()));
            sb.append('\n').append('\t');
            sb.append("Server Library: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getServerLibLocation()));
            sb.append('\n').append('\t');
            sb.append("Server Config: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getServerConfLocation()));
            sb.append('\n').append('\t');
            sb.append("Server Home: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getServerHomeLocation()));
            sb.append('\n').append('\t');
            sb.append("Server Data: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getServerDataLocation()));
            sb.append('\n').append('\t');
            sb.append("Server Log: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getServerLogLocation()));
            sb.append('\n').append('\t');
            sb.append("Server Temp: " + AbstractJBossASServerBase.getRelativePath(jbossHome, config.getServerTempLocation()));
            sb.append('\n');
            log.info((Object)sb.toString());
        }
    }

    private static String getRelativePath(String jbossHome, URL url) {
        if (url == null) {
            return "Not defined";
        }
        String urlString = url.toExternalForm();
        if (urlString.startsWith(jbossHome)) {
            urlString = "$JBOSS_HOME" + File.separatorChar + urlString.substring(jbossHome.length());
            return urlString;
        }
        return url.toExternalForm();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.setStartDate(new Date());
    }

    public void start() throws IllegalStateException, Exception {
        log.debugf("Starting: %s", new Object[]{this.version.toString(true)});
        super.start();
    }

    protected void setStartDate(Date startDate) {
        this.startDate = (Date)startDate.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBossAS [");
        sb.append(this.version.toString());
        sb.append("]");
        return sb.toString();
    }

    protected void setupBootstrapDescriptorsFromBootstrapUrl() {
        URL bootstrapUrl = ((JBossASBasedServerConfig)this.getConfiguration()).getBootstrapUrl();
        if (bootstrapUrl == null) {
            throw new IllegalStateException("Bootstrap URL should have been initialized");
        }
        BootstrapMetaData bmd = BootstrapParser.parse(bootstrapUrl);
        List urlStrings = bmd.getBootstrapURLs();
        URL bootstrapHome = ((JBossASBasedServerConfig)this.getConfiguration()).getBootstrapHome();
        List descriptors = ((JBossASBasedServerConfig)this.getConfiguration()).getBootstrapDescriptors();
        for (String urlString : urlStrings) {
            URL url;
            if (urlString.startsWith(SLASH)) {
                throw new InvalidBootstrapURLException("Specified URL starts with a \"/\": " + urlString);
            }
            try {
                url = new URL(bootstrapHome, urlString);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not construct URL from parent " + bootstrapHome + " and name " + urlString, e);
            }
            UrlBootstrapDescriptor descriptor = new UrlBootstrapDescriptor(url);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding bootstrap descriptor: " + descriptor));
            }
            descriptors.add(descriptor);
        }
    }
}

