/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.interceptors.aop.InterceptorsFactory;
import org.jboss.logging.Logger;

public class InterceptorsInterceptor {
    private static final Logger log = Logger.getLogger(InterceptorsInterceptor.class);

    public Object invokeBusinessMethodInterceptors(Invocation invocation) throws Throwable {
        assert (invocation instanceof MethodInvocation) : "Can only have business method interceptors on a method invocation";
        Interceptor[] interceptors = InterceptorsFactory.getBusinessMethodInterceptors((MethodInvocation)invocation);
        return invocation.getWrapper(interceptors).invokeNext();
    }

    public Object invokeClassInterceptors(Invocation invocation) throws Throwable {
        Interceptor[] interceptors = InterceptorsFactory.getClassInterceptors(invocation);
        return invocation.getWrapper(interceptors).invokeNext();
    }

    public Object invokeDefaultInterceptors(Invocation invocation) throws Throwable {
        log.warn((Object)"Invoking defaults interceptors is NYI");
        log.debug((Object)("advisor " + invocation.getAdvisor().getName()));
        return invocation.invokeNext();
    }

    public Object postConstruct(Invocation invocation) throws Throwable {
        log.warn((Object)"postConstruct is NYI");
        return null;
    }
}

