/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

final class NioPipeSourceChannel
implements StreamSourceChannel {
    private final Pipe.SourceChannel channel;
    private final NioHandle handle;
    private final NioXnio nioXnio;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final Closeable mbeanHandle;
    private volatile ChannelListener<? super StreamSourceChannel> readListener = null;
    private volatile ChannelListener<? super StreamSourceChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<NioPipeSourceChannel, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioPipeSourceChannel.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<NioPipeSourceChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioPipeSourceChannel.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<StreamSourceChannel> readSetter = IoUtils.getSetter((Object)this, readListenerUpdater);
    private final ChannelListener.Setter<StreamSourceChannel> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);

    NioPipeSourceChannel(Pipe.SourceChannel channel, NioXnio nioXnio, Closeable mbeanHandle) throws IOException {
        this.channel = channel;
        this.nioXnio = nioXnio;
        this.mbeanHandle = mbeanHandle;
        this.handle = nioXnio.addReadHandler(channel, new Handler());
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this.channel, position, count);
    }

    public ChannelListener.Setter<StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public int read(ByteBuffer dst) throws IOException {
        int ret = this.channel.read(dst);
        return ret;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long ret = this.channel.read(dsts);
        return ret;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = this.channel.read(dsts, offset, length);
        return ret;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            this.nioXnio.removeManaged((Closeable)((Object)this));
            IoUtils.safeClose((Closeable)this.mbeanHandle);
            IoUtils.invokeChannelListener((Channel)((Object)this), this.closeListener);
            this.channel.close();
        }
    }

    public void suspendReads() {
        try {
            this.handle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.handle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownReads() throws IOException {
        this.close();
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 1, time, timeUnit);
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        return null;
    }

    public <T> NioPipeSourceChannel setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this;
    }

    public String toString() {
        return String.format("pipe source channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private final class Handler
    implements Runnable {
        private Handler() {
        }

        @Override
        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioPipeSourceChannel.this), (ChannelListener)NioPipeSourceChannel.this.readListener);
        }
    }
}

