/*
 * Decompiled with CFR 0.152.
 */
package be.e_contract.eid.chrome.installer;

import be.e_contract.eid.chrome.installer.ChromeMessages;
import be.e_contract.eid.chrome.installer.ChromeRegistrationException;
import be.e_contract.eid.chrome.installer.ManifestGenerator;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;

public class ChromeRegistration {
    private final InstallData installData;
    private final RegistryDefaultHandler handler;

    public ChromeRegistration(InstallData installData, RegistryDefaultHandler handler) {
        this.installData = installData;
        this.handler = handler;
    }

    public ChromeMessages chromeRegistration() throws ChromeRegistrationException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            PrintWriter printWriter;
            File userHome = new File(System.getProperty("user.home"));
            File chromeNativeMessagingHostsDir = new File(userHome, ".config/google-chrome/NativeMessagingHosts");
            if (!chromeNativeMessagingHostsDir.exists()) {
                chromeNativeMessagingHostsDir.mkdirs();
            }
            String installPath = this.installData.getInstallPath();
            File chromeManifestFile = new File(chromeNativeMessagingHostsDir, "be.econtract.eid.json");
            String shPath = installPath + "/eid-chrome-mw.sh";
            String extensionIdentifier = this.installData.getVariable("eid.chrome.extension.identifier");
            ManifestGenerator manifestGenerator = new ManifestGenerator(shPath, extensionIdentifier);
            String manifest = manifestGenerator.generate();
            try {
                FileUtils.writeStringToFile(chromeManifestFile, manifest);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("IO error writing manifest file");
            }
            File chromiumNativeMessagingHostsDir = new File(userHome, ".config/chromium/NativeMessagingHosts");
            if (!chromiumNativeMessagingHostsDir.exists()) {
                chromiumNativeMessagingHostsDir.mkdirs();
            }
            File chromiumManifestFile = new File(chromiumNativeMessagingHostsDir, "be.econtract.eid.json");
            try {
                FileUtils.writeStringToFile(chromiumManifestFile, manifest);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("IO error writing manifest file");
            }
            File vivaldiNativeMessagingHostsDir = new File(userHome, ".config/vivaldi/NativeMessagingHosts");
            if (!vivaldiNativeMessagingHostsDir.exists()) {
                vivaldiNativeMessagingHostsDir.mkdirs();
            }
            File vivaldiManifestFile = new File(vivaldiNativeMessagingHostsDir, "be.econtract.eid.json");
            try {
                FileUtils.writeStringToFile(vivaldiManifestFile, manifest);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("IO error writing manifest file");
            }
            File shFile = new File(shPath);
            try {
                printWriter = new PrintWriter(shFile);
            }
            catch (FileNotFoundException ex) {
                throw new ChromeRegistrationException("File not found: " + shFile.getAbsolutePath());
            }
            printWriter.println("#!/bin/bash");
            printWriter.println("cd " + installPath);
            String appVersion = this.installData.getInfo().getAppVersion();
            printWriter.println("java -jar eid-chrome-mw-" + appVersion + ".jar");
            printWriter.close();
            HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
            filePermissions.add(PosixFilePermission.OWNER_READ);
            filePermissions.add(PosixFilePermission.OWNER_EXECUTE);
            filePermissions.add(PosixFilePermission.OWNER_WRITE);
            Path shFilePath = Paths.get(shPath, new String[0]);
            try {
                Files.setPosixFilePermissions(shFilePath, filePermissions);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("Could not change file permissions: " + shFile.getAbsolutePath());
            }
            return ChromeMessages.SUCCESS_LINUX;
        }
        if (osName.startsWith("Windows")) {
            PrintWriter printWriter;
            String installPath = this.installData.getInstallPath();
            File batchFile = new File(installPath, "eid-chrome-mw.bat");
            try {
                printWriter = new PrintWriter(batchFile);
            }
            catch (FileNotFoundException ex) {
                throw new ChromeRegistrationException("File not found: " + batchFile.getAbsolutePath());
            }
            printWriter.println("@echo off");
            printWriter.println("cd " + installPath);
            String appVersion = this.installData.getInfo().getAppVersion();
            printWriter.println("\"" + System.getProperty("java.home") + "\\bin\\java.exe\" -jar eid-chrome-mw-" + appVersion + ".jar");
            printWriter.close();
            File manifestFile = new File(installPath, "eid-chrome-mw-manifest.json");
            String extensionIdentifier = this.installData.getVariable("eid.chrome.extension.identifier");
            ManifestGenerator manifestGenerator = new ManifestGenerator("eid-chrome-mw-" + appVersion + ".exe", extensionIdentifier);
            String manifest = manifestGenerator.generate();
            try {
                FileUtils.writeStringToFile(manifestFile, manifest);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("IO error writing manifest file");
            }
            RegistryHandler registryHandler = this.handler.getInstance();
            try {
                registryHandler.activateLogging();
                try {
                    registryHandler.setRoot(-2147483646);
                    registryHandler.setValue("SOFTWARE\\Google\\Chrome\\NativeMessagingHosts\\be.econtract.eid", "", manifestFile.getAbsolutePath());
                }
                catch (Exception chromiumManifestFile) {
                    // empty catch block
                }
                registryHandler.setRoot(-2147483647);
                registryHandler.setValue("SOFTWARE\\Google\\Chrome\\NativeMessagingHosts\\be.econtract.eid", "", manifestFile.getAbsolutePath());
            }
            catch (NativeLibException ex) {
                throw new ChromeRegistrationException("Cannot write to Windows registry.");
            }
            return ChromeMessages.SUCCESS_WINDOWS;
        }
        if (osName.contains("OS X")) {
            PrintWriter printWriter;
            File userHome = new File(System.getProperty("user.home"));
            String installPath = this.installData.getInstallPath();
            String shPath = installPath + "/eid-chrome-mw.sh";
            String extensionIdentifier = this.installData.getVariable("eid.chrome.extension.identifier");
            ManifestGenerator manifestGenerator = new ManifestGenerator(shPath, extensionIdentifier);
            String manifest = manifestGenerator.generate();
            File chromeNativeMessagingHostsDir = new File(userHome, "/Library/Application Support/Google/Chrome/NativeMessagingHosts");
            if (!chromeNativeMessagingHostsDir.exists()) {
                chromeNativeMessagingHostsDir.mkdirs();
            }
            File chromeManifestFile = new File(chromeNativeMessagingHostsDir, "be.econtract.eid.json");
            try {
                FileUtils.writeStringToFile(chromeManifestFile, manifest);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("IO error writing manifest file");
            }
            File chromiumNativeMessagingHostsDir = new File(userHome, "/Library/Application Support/Chromium/NativeMessagingHosts");
            if (!chromiumNativeMessagingHostsDir.exists()) {
                chromiumNativeMessagingHostsDir.mkdirs();
            }
            File chromiumManifestFile = new File(chromiumNativeMessagingHostsDir, "be.econtract.eid.json");
            try {
                FileUtils.writeStringToFile(chromiumManifestFile, manifest);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("IO error writing manifest file");
            }
            File vivaldiNativeMessagingHostsDir = new File(userHome, "/Library/Application Support/Vivaldi/NativeMessagingHosts");
            if (!vivaldiNativeMessagingHostsDir.exists()) {
                vivaldiNativeMessagingHostsDir.mkdirs();
            }
            File vivaldiManifestFile = new File(vivaldiNativeMessagingHostsDir, "be.econtract.eid.json");
            try {
                FileUtils.writeStringToFile(vivaldiManifestFile, manifest);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("IO error writing manifest file");
            }
            File shFile = new File(shPath);
            try {
                printWriter = new PrintWriter(shFile);
            }
            catch (FileNotFoundException ex) {
                throw new ChromeRegistrationException("File not found: " + shFile.getAbsolutePath());
            }
            printWriter.println("#!/bin/bash");
            printWriter.println("cd " + installPath);
            String appVersion = this.installData.getInfo().getAppVersion();
            printWriter.println("MAC_JRE_JAVA=\"/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java\"");
            printWriter.println("if [ -f \"$MAC_JRE_JAVA\" ]");
            printWriter.println("then");
            printWriter.println("\tJAVA_EXEC=\"$MAC_JRE_JAVA\"");
            printWriter.println("else");
            printWriter.println("\tJAVA_EXEC=java");
            printWriter.println("fi");
            printWriter.println("\"$JAVA_EXEC\" -jar eid-chrome-mw-" + appVersion + ".jar");
            printWriter.close();
            HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
            filePermissions.add(PosixFilePermission.OWNER_READ);
            filePermissions.add(PosixFilePermission.OWNER_EXECUTE);
            filePermissions.add(PosixFilePermission.OWNER_WRITE);
            Path shFilePath = Paths.get(shPath, new String[0]);
            try {
                Files.setPosixFilePermissions(shFilePath, filePermissions);
            }
            catch (IOException ex) {
                throw new ChromeRegistrationException("Could not change file permissions: " + shFile.getAbsolutePath());
            }
            return ChromeMessages.SUCCESS_MAC;
        }
        throw new ChromeRegistrationException("unsupported operating system.");
    }
}

