/*
 * Decompiled with CFR 0.152.
 */
package be.e_contract.eid.chrome.installer;

import be.e_contract.eid.chrome.installer.ChromeMessages;
import be.e_contract.eid.chrome.installer.ChromeRegistration;
import be.e_contract.eid.chrome.installer.ChromeRegistrationException;
import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Component;
import java.awt.LayoutManager2;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ChromePanel
extends IzPanel {
    private final JLabel chromeLocationLabel;
    private final RegistryDefaultHandler handler;

    public ChromePanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log, RegistryDefaultHandler handler) {
        this(panel, parent, installData, new IzPanelLayout(log), resources, handler);
    }

    private ChromePanel(Panel panel, InstallerFrame parent, GUIInstallData installData, LayoutManager2 layout, Resources resources, RegistryDefaultHandler handler) {
        super(panel, parent, installData, layout, resources);
        this.handler = handler;
        String welcomeText = this.getString(ChromeMessages.WELCOME);
        JLabel welcomeLabel = LabelFactory.create(welcomeText, (Icon)parent.getIcons().get("host"), 10);
        welcomeLabel.setName(GuiId.HELLO_PANEL_LABEL.id);
        this.add((Component)welcomeLabel, "nextLine");
        this.add(IzPanelLayout.createParagraphGap());
        this.chromeLocationLabel = new JLabel("Status:");
        this.add((Component)this.chromeLocationLabel, "nextLine");
        this.getLayoutHelper().completeLayout();
    }

    private String getString(ChromeMessages chromeMessages) {
        return this.getString(chromeMessages.getId());
    }

    @Override
    public void panelActivate() {
        ChromeRegistration chromeRegistration = new ChromeRegistration(this.installData, this.handler);
        try {
            ChromeMessages statusChromeMessage = chromeRegistration.chromeRegistration();
            String status = this.getString(statusChromeMessage);
            this.chromeLocationLabel.setText("Status: " + status);
        }
        catch (ChromeRegistrationException ex) {
            this.chromeLocationLabel.setText("Status: could not register the eID Chrome Middleware.");
            super.emitErrorAndBlockNext("Error", ex.getMessage());
        }
    }
}

