/*
 * Decompiled with CFR 0.152.
 */
package be.e_contract.eid.chrome.installer;

import be.e_contract.eid.chrome.installer.ChromeMessages;
import be.e_contract.eid.chrome.installer.ChromeRegistration;
import be.e_contract.eid.chrome.installer.ChromeRegistrationException;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import java.util.Properties;

public class ChromeConsolePanel
extends AbstractConsolePanel {
    private final RegistryDefaultHandler handler;

    public ChromeConsolePanel(PanelView<ConsolePanel> panel, RegistryDefaultHandler handler) {
        super(panel);
        this.handler = handler;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        ChromeRegistration chromeRegistration = new ChromeRegistration(installData, this.handler);
        try {
            chromeRegistration.chromeRegistration();
        }
        catch (ChromeRegistrationException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        Messages messages = installData.getMessages();
        String welcomeText = messages.get(ChromeMessages.WELCOME.getId(), new Object[0]);
        console.println(welcomeText);
        ChromeRegistration chromeRegistration = new ChromeRegistration(installData, this.handler);
        try {
            ChromeMessages chromeStatus = chromeRegistration.chromeRegistration();
            String status = messages.get(chromeStatus.getId(), new Object[0]);
            console.println("Status: " + status);
        }
        catch (ChromeRegistrationException ex) {
            console.println("Error: " + ex.getMessage());
            return false;
        }
        return true;
    }
}

