/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuBarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.AWTAccessor;

public class MenuBar
extends MenuComponent
implements MenuContainer,
Accessible {
    Vector<Menu> menus = new Vector();
    Menu helpMenu;
    private static final String base = "menubar";
    private static int nameCounter;
    private static final long serialVersionUID = -4930327919388951260L;
    private int menuBarSerializedDataVersion = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<MenuBar> clazz = MenuBar.class;
        synchronized (MenuBar.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
            }
            int n = this.getMenuCount();
            for (int i = 0; i < n; ++i) {
                this.getMenu(i).addNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getMenuCount();
            for (int i = 0; i < n; ++i) {
                this.getMenu(i).removeNotify();
            }
            super.removeNotify();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHelpMenu(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.helpMenu == menu) {
                return;
            }
            if (this.helpMenu != null) {
                this.remove(this.helpMenu);
            }
            this.helpMenu = menu;
            if (menu != null) {
                if (menu.parent != this) {
                    this.add(menu);
                }
                menu.isHelpMenu = true;
                menu.parent = this;
                MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
                if (menuBarPeer != null) {
                    if (menu.peer == null) {
                        menu.addNotify();
                    }
                    menuBarPeer.addHelpMenu(menu);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Menu add(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menu.parent != null) {
                menu.parent.remove(menu);
            }
            this.menus.addElement(menu);
            menu.parent = this;
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                if (menu.peer == null) {
                    menu.addNotify();
                }
                menuBarPeer.addMenu(menu);
            }
            return menu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Menu menu = this.getMenu(n);
            this.menus.removeElementAt(n);
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                menu.removeNotify();
                menu.parent = null;
                menuBarPeer.delMenu(n);
            }
            if (this.helpMenu == menu) {
                this.helpMenu = null;
                menu.isHelpMenu = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.menus.indexOf(menuComponent);
            if (n >= 0) {
                this.remove(n);
            }
        }
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    @Deprecated
    public int countMenus() {
        return this.getMenuCountImpl();
    }

    final int getMenuCountImpl() {
        return this.menus.size();
    }

    public Menu getMenu(int n) {
        return this.getMenuImpl(n);
    }

    final Menu getMenuImpl(int n) {
        return this.menus.elementAt(n);
    }

    public synchronized Enumeration<MenuShortcut> shortcuts() {
        Vector<MenuShortcut> vector = new Vector<MenuShortcut>();
        int n = this.getMenuCount();
        for (int i = 0; i < n; ++i) {
            Enumeration<MenuShortcut> enumeration = this.getMenu(i).shortcuts();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.getMenuCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = this.getMenu(i).getShortcutMenuItem(menuShortcut);
            if (menuItem == null) continue;
            return menuItem;
        }
        return null;
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        if (n != 401 && n != 402) {
            return false;
        }
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((keyEvent.getModifiers() & n2) == 0) {
            return false;
        }
        int n3 = this.getMenuCount();
        for (int i = 0; i < n3; ++i) {
            Menu menu = this.getMenu(i);
            if (!menu.handleShortcut(keyEvent)) continue;
            return true;
        }
        return false;
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        int n = this.getMenuCount();
        for (int i = 0; i < n; ++i) {
            this.getMenu(i).deleteShortcut(menuShortcut);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < this.menus.size(); ++i) {
            Menu menu = this.menus.elementAt(i);
            menu.parent = this;
        }
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    @Override
    int getAccessibleChildIndex(MenuComponent menuComponent) {
        return this.menus.indexOf(menuComponent);
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuBar.initIDs();
        }
        AWTAccessor.setMenuBarAccessor(new AWTAccessor.MenuBarAccessor(){

            @Override
            public Menu getHelpMenu(MenuBar menuBar) {
                return menuBar.helpMenu;
            }

            @Override
            public Vector<Menu> getMenus(MenuBar menuBar) {
                return menuBar.menus;
            }
        });
        nameCounter = 0;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        private static final long serialVersionUID = -8577604491830083815L;

        protected AccessibleAWTMenuBar() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

